<!doctype html>
@if(\App\Models\Language::where('code', Session::get('locale', Config::get('app.locale')))->first()->rtl == 1)
<html dir="rtl" lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@else
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
@endif
<head>
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<meta name="app-url" content="{{ getBaseURL() }}">
	<meta name="file-base-url" content="{{ getFileBaseURL() }}">

	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<!-- Favicon -->
	<link rel="icon" href="{{ uploaded_asset(get_setting('site_icon')) }}">
	<title>{{ get_setting('website_name').' | '.get_setting('site_motto') }}</title>

	<!-- google font -->
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700">

	<!-- aiz core css -->
	<link rel="stylesheet" href="{{ static_asset('assets/css/vendors.css') }}">
    @if(\App\Models\Language::where('code', Session::get('locale', Config::get('app.locale')))->first()->rtl == 1)
    <link rel="stylesheet" href="{{ static_asset('assets/css/bootstrap-rtl.min.css') }}">
    @endif
	<link rel="stylesheet" href="{{ static_asset('assets/css/aiz-core.css?v=') }}{{ rand(1000,9999) }}">

    <style>
        body {
            font-size: 12px;
        }
    </style>
	<script>
    	var AIZ = AIZ || {};
        AIZ.local = {
            nothing_selected: '{{ translate('Nada selecionado') }}',
            nothing_found: '{{ translate('Nada encontrado') }}',
            choose_file: '{{ translate('Escolha o arquivo') }}',
            file_selected: '{{ translate('Arquivo selecionado') }}',
            files_selected: '{{ translate('Arquivos selecionados') }}',
            add_more_files: '{{ translate('Adicione mais arquivos') }}',
            adding_more_files: '{{ translate('Adicionando mais arquivos') }}',
            drop_files_here_paste_or: '{{ translate('Solte os arquivos aqui, cole ou') }}',
            browse: '{{ translate('Navegar') }}',
            upload_complete: '{{ translate('Carregamento concluído') }}',
            upload_paused: '{{ translate('Carregamento pausado') }}',
            resume_upload: '{{ translate('Retomar upload') }}',
            pause_upload: '{{ translate('Pausar upload') }}',
            retry_upload: '{{ translate('Tentar enviar novamente') }}',
            cancel_upload: '{{ translate('Cancelar upload') }}',
            uploading: '{{ translate('Enviando') }}',
            processing: '{{ translate('Processamento') }}',
            complete: '{{ translate('Completo') }}',
            file: '{{ translate('Arquivo') }}',
            files: '{{ translate('Arquivos') }}',
        }
	</script>

</head>
<body class="">

	<div class="aiz-main-wrapper d-flex">
        <div class="flex-grow-1">
            @yield('content')
        </div>
    </div><!-- .aiz-main-wrapper -->

    @yield('modal')


    <script src="{{ static_asset('assets/js/vendors.js') }}" ></script>
    <script src="{{ static_asset('assets/js/aiz-core.js?v=') }}{{ rand(1000,9999) }}" ></script>

    @yield('script')

    <script type="text/javascript">
        @foreach (session('flash_notification', collect())->toArray() as $message)
            AIZ.plugins.notify('{{ $message['level'] }}', '{{ $message['message'] }}');
        @endforeach
    </script>

</body>
</html>