@extends('backend.layouts.app')

@section('content')
<div class="col-lg-6 mx-auto">
    <div class="card">
        <div class="card-body" style="background-color: #fcfcfc; min-height:460px;">
            <form class="form-horizontal" action="{{ route('business_settings.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @php
                    $notification_show_type = get_setting('notification_show_type');
                @endphp
                <input type="hidden" name="types[]" value="notification_show_type">
                <h1 class="fs-13 fw-700 mb-3">{{translate('Configurações de notificação')}}</h1>
                <p>{{ translate('Você pode adicionar novos tipos e fazer upload de imagens para cada tipo. Se você não fizer upload de imagens ou editar imagens de tipos padrão, a imagem padrão será mostrada.') }}</p>
                <div class="row mt-md-5 gutters-20">
                    <div class="col-md-6 mb-4">
                        <div class="shadow-lg bg-white rounded">
                            <p class="px-4 py-2">{{ translate('Código do pedido') }} : <span class="fw-600 text-blue">20220912-10085522</span> {{ translate('foi entregue') }}</p>
                        </div>
                        <div class="align-items-center d-flex">
                            <input id="only_text" class="magic-radio" type="radio" name="notification_show_type" value="only_text" @if($notification_show_type == 'only_text') checked @endif>
                            <label for="only_text" class="mb-0 ml-2">{{translate('Apenas texto')}}</label>
                        </div>
                    </div>
                    <div class="col-md-6 mb-4">
                        <div class="shadow-lg bg-white rounded d-flex align-items-center px-4 py-2">
                            <img src="{{ static_asset('assets/img/notification.png') }}" height="35">
                            <span class="pl-2">{{ translate('Código do pedido') }} : <span class="fw-600 text-blue">20220912-10085522</span> {{ translate('foi entregue') }}</span>
                        </div>
                        <div class="align-items-center d-flex mt-3">
                            <input id="design_1" class="magic-radio" type="radio" name="notification_show_type" value="design_1" @if($notification_show_type == 'design_1') checked @endif>
                            <label for="design_1" class="mb-0 ml-2">{{translate('Projeto 1')}}</label>
                        </div>
                    </div>
                    <div class="col-md-6 mb-4">
                        <div class="shadow-lg bg-white rounded d-flex align-items-center px-4 py-2">
                            <img src="{{ static_asset('assets/img/notification.png') }}" height="35" class="rounded-1">
                            <span class="pl-2">{{ translate('Código do pedido') }} : <span class="fw-600 text-blue">20220912-10085522</span> {{ translate('foi entregue') }}</span>
                        </div>
                        <div class="align-items-center d-flex mt-3">
                            <input id="design_2" class="magic-radio" type="radio" name="notification_show_type" value="design_2" @if($notification_show_type == 'design_2') checked @endif>
                            <label for="design_2" class="mb-0 ml-2">{{translate('Projeto 2')}}</label>
                        </div>
                    </div>
                    <div class="col-md-6 mb-4">
                        <div class="shadow-lg bg-white rounded d-flex align-items-center px-4 py-2">
                            <img src="{{ static_asset('assets/img/notification.png') }}" height="35" class="rounded-circle">
                            <span class="pl-2">{{ translate('Código do pedido') }} : <span class="fw-600 text-blue">20220912-10085522</span> {{ translate('foi entregue') }}</span>
                        </div>
                        <div class="align-items-center d-flex mt-3">
                            <input id="design_3" class="magic-radio" type="radio" name="notification_show_type" value="design_3" @if($notification_show_type == 'design_3') checked @endif>
                            <label for="design_3" class="mb-0 ml-2">{{translate('Projeto 3')}}</label>
                        </div>
                    </div>
                </div>
                <div class="float-right my-3">
                    <button type="submit" class="btn btn-primary btn-sm fw-700 rounded-2 shadow-primary w-140px">{{ translate('Salvar') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
