@extends('backend.layouts.app')

@section('content')

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6">{{translate('Upload em massa de marca')}}</h5>
        </div>
        <div class="card-body">
            <div class="alert" style="color: #004085;background-color: #cce5ff;border-color: #b8daff;margin-bottom:0;margin-top:10px;">
                <strong>{{ translate('Passo 1')}}:</strong>
                <p>1. {{translate('Baixe o arquivo do esqueleto e preencha-o com os dados adequados')}}.</p>
                <p>2. {{translate('Você pode baixar o arquivo de exemplo para entender como os dados devem ser preenchidos')}}.</p>
                <p>3. {{translate('Depois de baixar e preencher o arquivo esqueleto, carregue-o no formulário abaixo e envie')}}.</p>
            </div>
            <br>
            <div class="">
                <a href="{{ static_asset('download/brand_bulk_demo.xlsx') }}" download><button class="btn btn-info">{{ translate('Baixar CSV')}}</button></a>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6"><strong>{{translate('Carregar arquivo de marca')}}</strong></h5>
        </div>
        <div class="card-body">
            <form class="form-horizontal" action="{{ route('brand_bulk_upload') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="form-group row">
                    <div class="col-sm-9">
                        <div class="custom-file">
    						<label class="custom-file-label">
    							<input type="file" name="bulk_file" class="custom-file-input" required>
    							<span class="custom-file-name">{{ translate('Escolha arquivo')}}</span>
    						</label>
    					</div>
                    </div>
                </div>
                <div class="form-group mb-0">
                    <button type="submit" class="btn btn-info">{{translate('Carregar CSV')}}</button>
                </div>
            </form>
        </div>
    </div>

@endsection
