@extends('backend.layouts.app')

@section('content')

<div class="aiz-titlebar text-left mt-2 mb-3">
    <div class="row align-items-center">
        <div class="col-auto">
            <h1 class="h3">{{translate('Todas as avaliações e comentários')}}</h1>
        </div>
        @can('add_custom_review')
            <div class="col text-right">
                <a href="{{ route('custom-review.create', null) }}" class="btn btn-sm rounded-2" style="background-color: #299395; color: white;">
                    <span>{{translate('Adicionar avaliações personalizadas')}}</span>
                </a>
            </div>
        @endcan
    </div>
</div>
<br>

<div class="card">
    <form class="" action="" id="sort_reiewed_products" method="GET">
        <div class="card-header row gutters-5">
            <div class="col">
                <h5 class="mb-0 h6">{{ translate('Análise e classificações do produto') }}</h5>
            </div>

            <div class="col-lg-2 ml-auto">
                <select class="form-control form-control-sm aiz-selectpicker" name="seller_id" id="seller_id" onchange="sort_reiewed_products()" data-selected="{{ $sellerID }}" >
                    <option value="all">{{ translate('Todos') }}</option>
                    <option value="{{ get_admin()->id }}">{{ translate('Em casa') }}</option>
                    @foreach ($sellers as $seller)
                        <option value="{{ $seller->id }}">{{ $seller->name }}</option>
                    @endforeach
                    
                </select>
            </div>
            <div class="col-lg-2">
                <select class="form-control form-control-sm aiz-selectpicker" name="rating" id="rating" onchange="sort_reiewed_products()" data-selected="{{ $sortByRating }}">
                    <option value="">{{translate('Filtrar por classificação')}}</option>
                    <option value="desc">{{translate('Classificação (Alta > Baixa)')}}</option>
                    <option value="asc">{{translate('Classificação (Baixa > Alta)')}}</option>
                </select>
            </div>
            <div class="col-lg-2">
                <div class="form-group form-group-sm mb-0">
                    <input type="text" class="form-control form-control-sm" id="search"
                        name="search" value="{{ $sortSearch }}"
                        placeholder="{{ translate('Digite o nome do produto e pressione Enter') }}">
                </div>
            </div>
        </div>
    </form>
    <div class="card-body">
        <table class="table aiz-table mb-0">
            <thead>
                <tr>
                    <th data-breakpoints="lg">#</th>
                    <th width="40%">{{translate('Nome do produto')}}</th>
                    <th data-breakpoints="lg">{{translate('Proprietário do Produto')}}</th>
                    <th data-breakpoints="lg">{{translate('Avaliação')}}</th>
                    <th data-breakpoints="lg">{{translate('Avaliações')}}</th>
                    <th data-breakpoints="lg">{{translate('Avaliações personalizadas')}}</th>
                    <th class="text-right">{{translate('Opções')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($products as $key => $product)
                <tr>
                    <td>{{ ($key+1) + ($products->currentPage() - 1)*$products->perPage() }}</td>
                    <td>
                        <div class="row gutters-5">
                            <div class="col-auto">
                                <img src="{{ uploaded_asset($product->thumbnail_img)}}" alt="Image" class="size-50px img-fit">
                            </div>
                            <div class="col">
                                <span class="text-muted text-truncate-2">{{ $product->getTranslation('name') }}</span>
                            </div>
                        </div>
                    </td>
                    <td>{{ $product->user->name}}</td>
                    <td>{{ $product->rating}}</td>
                    <td>
                        {{ $product->reviews->count()}}
                        @if($product->reviews()->where('viewed',0)->count() > 0)
                            <span class="badge badge-inline badge-danger">{{ translate('novo') }}</span>
                        @endif
                    </td>
                    <td>{{ $product->reviews->where('type','custom')->count()}}</td>
                    <td>
                        <div class="form-group mb-0 text-right">
                            <a href="{{ route('detail-reviews', $product->id) }}" class="btn btn-primary btn-sm rounded-2">{{ translate('Ver avaliações') }}</a>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="aiz-pagination">
            {{ $products->appends(request()->input())->links() }}
        </div>
    </div>
</div>

@endsection

@section('script')
    <script type="text/javascript">
        
        function sort_reiewed_products(el){
            $('#sort_reiewed_products').submit();
        }
    </script>
@endsection
