@extends('backend.layouts.app')

@section('content')

<div class="aiz-titlebar text-left mt-2 mb-3">
    <h5 class="mb-0 h6">{{translate('Editar informações do vendedor')}}</h5>
</div>

<div class="col-lg-6 mx-auto">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6">{{translate('Informações do vendedor')}}</h5>
        </div>

        <div class="card-body">
          <form action="{{ route('sellers.update', $shop->id) }}" method="POST">
                <input name="_method" type="hidden" value="PATCH">
                @csrf
                <div class="form-group row">
                    <label class="col-sm-3 col-from-label" for="name">{{translate('Nome')}}</label>
                    <div class="col-sm-9">
                        <input type="text" placeholder="{{translate('Nome')}}" id="name" name="name" class="form-control" value="{{$shop->user->name}}" required>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-3 col-from-label" for="email">{{translate('Endereço de email')}}</label>
                    <div class="col-sm-9">
                        <input type="text" placeholder="{{translate('Endereço de email')}}" id="email" name="email" class="form-control" value="{{$shop->user->email}}" required>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-3 col-from-label" for="password">{{translate('Senha')}}</label>
                    <div class="col-sm-9">
                        <input type="password" placeholder="{{translate('Senha')}}" id="password" name="password" class="form-control">
                    </div>
                </div>
                <div class="form-group mb-0 text-right">
                    <button type="submit" class="btn btn-primary">{{translate('Salvar')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
