<form action="{{ route('commissions.pay_to_seller') }}" method="POST">
    @csrf
    <input type="hidden" name="shop_id" value="{{ $shop->id }}">
    <div class="modal-header">
    	<h5 class="modal-title h6">{{translate('Pagar ao vendedor')}}</h5>
    	<button type="button" class="close" data-dismiss="modal">
    	</button>
    </div>
    <div class="modal-body">
      <table class="table table-striped table-bordered" >
          <tbody>
              <tr>
                  @if($shop->admin_to_pay >= 0)
                      <td>{{ translate('Devido ao vendedor') }}</td>
                      <td>{{ single_price($shop->admin_to_pay) }}</td>
                  @else
                      <td>{{ translate('Devido ao administrador') }}</td>
                      <td>{{ single_price(abs($shop->admin_to_pay)) }}</td>
                  @endif
              </tr>
              @if ($shop->bank_payment_status == 1)
                  <tr>
                      <td>{{ translate('Nome do banco') }}</td>
                      <td>{{ $shop->bank_name }}</td>
                  </tr>
                  <tr>
                      <td>{{ translate('Nome da conta bancária') }}</td>
                      <td>{{ $shop->bank_acc_name }}</td>
                  </tr>
                  <tr>
                      <td>{{ translate('Número da conta bancária') }}</td>
                      <td>{{ $shop->bank_acc_no }}</td>
                  </tr>
                  <tr>
                      <td>{{ translate('Número de roteamento bancário') }}</td>
                      <td>{{ $shop->bank_routing_no }}</td>
                  </tr>
              @endif
          </tbody>
      </table>

      @if ($shop->admin_to_pay > 0)
          <div class="form-group row">
              <label class="col-md-3 col-from-label" for="amount">{{translate('Quantia')}}</label>
              <div class="col-md-9">
                  <input type="number" lang="en" min="0" step="0.01" name="amount" id="amount" value="{{ $shop->admin_to_pay }}" class="form-control" required>
              </div>
          </div>

          <div class="form-group row">
              <label class="col-md-3 col-from-label" for="payment_option">{{translate('Método de pagamento')}}</label>
              <div class="col-md-9">
                  <select name="payment_option" id="payment_option" class="form-control aiz-selectpicker" required>
                      <option value="">{{translate('Selecione a forma de pagamento')}}</option>
                      @if($shop->cash_on_delivery_status == 1)
                          <option value="cash">{{translate('Dinheiro')}}</option>
                      @endif
                      @if($shop->bank_payment_status == 1)
                          <option value="bank_payment">{{translate('Pagamento Bancário')}}</option>
                      @endif
                  </select>
              </div>
          </div>
          <div class="form-group row" id="txn_div">
              <label class="col-md-3 col-from-label" for="txn_code">{{translate('Código Txn')}}</label>
              <div class="col-md-9">
                  <input type="text" name="txn_code" id="txn_code" class="form-control">
              </div>
          </div>
      @else
          <div class="form-group row">
              <label class="col-md-3 col-from-label" for="amount">{{translate('Quantia')}}</label>
              <div class="col-md-9">
                  <input type="number" lang="en" min="0" step="0.01" name="amount" id="amount" value="{{ abs($shop->admin_to_pay) }}" class="form-control" required>
              </div>
          </div>
          <div class="form-group row" id="txn_div">
              <label class="col-md-3 col-from-label" for="txn_code">{{translate('Código Txn')}}</label>
              <div class="col-md-9">
                  <input type="text" name="txn_code" id="txn_code" class="form-control">
              </div>
          </div>
      @endif
    </div>
    <div class="modal-footer">
      @if ($shop->admin_to_pay > 0)
          <button type="submit" class="btn btn-primary">{{translate('Pagar')}}</button>
      @else
          <button type="submit" class="btn btn-primary">{{translate('Liquidar devido')}}</button>
      @endif
      <button type="button" class="btn btn-light" data-dismiss="modal">{{translate('Cancelar')}}</button>
    </div>
</form>

<script>
  $(document).ready(function(){
      $('#payment_option').on('change', function() {
        if ( this.value == 'bank_payment')
        {
          $("#txn_div").show();
        }
        else
        {
          $("#txn_div").hide();
        }
      });
      $("#txn_div").hide();
      AIZ.plugins.bootstrapSelect('refresh');
  });
</script>
