@extends('backend.layouts.app')

@section('content')
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0 h6">{{translate('Configuração do Google reCAPTCHA')}}</h3>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('google_recaptcha.update') }}" method="POST">
                        @csrf
                        <div class="form-group row">
                            <div class="col-md-4">
                                <label class="control-label">{{translate('Google reCAPTCHA')}}</label>
                            </div>
                            <div class="col-md-8">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input value="1" name="google_recaptcha" type="checkbox" @if (get_setting('google_recaptcha') == 1)
                                        checked
                                    @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="CAPTCHA_KEY">
                            <div class="col-md-4">
                                <label class="control-label">{{translate('CHAVE DO SITE')}}</label>
                            </div>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="CAPTCHA_KEY" value="{{  env('CAPTCHA_KEY') }}" placeholder="{{ translate('CHAVE DO SITE') }}" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="RECAPTCHA_SECRET_KEY">
                            <div class="col-md-4">
                                <label class="control-label">{{translate('CHAVE SECRETA')}}</label>
                            </div>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="RECAPTCHA_SECRET_KEY" value="{{  env('RECAPTCHA_SECRET_KEY') }}" placeholder="{{ translate('CHAVE SECRETA') }}" required>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{translate('Salvar')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
