@extends('backend.layouts.app')

@section('content')
	<div class="row">
		<div class="col-lg-8 col-xxl-6 mx-auto">
			<div class="card">
				<div class="card-header d-block d-md-flex">
					<h3 class="h6 mb-0">{{ translate('Importar dados de demonstração') }}</h3>
					<span>{{ translate('Versão atual') }}: {{ get_setting('current_version') }}</span>
				</div>
				<div class="card-body">
					<div class="alert alert-warning mb-5">
						<ul class="mb-0">
							<li class="">
								{{ translate('Certifique-se de que seu servidor atenda a todos os requisitos.') }}
								<a href="{{route('system_server')}}">{{ translate('Verifique aqui') }}</a>
							</li>
							<li class="">{{ translate('O upload pode demorar algum tempo, portanto não feche o navegador ou a guia.') }}</li>
							<li class="">{{ translate('Se você tiver dados anteriores, isso poderá entrar em conflito com alguns dos seus dados atuais.') }}</li>
							<li class="">{{ translate('Certifique-se de ter ativado seu sistema com o domínio e URL do site.') }}</li>
						</ul>
					</div>
					<form action="{{ route('import_data') }}" method="post" enctype="multipart/form-data">
						@csrf
						<!-- Product Name -->
						<div class="form-group row">
							<label class="col-xxl-3 col-from-label fs-13">{{translate('Nome do produto')}} <span class="text-danger">*</span></label>
							<div class="col-xxl-9">
								<select name="layout" class="form-control aiz-selectpicker mb-2 mb-md-0" required>
                                    <option value="classic">Classic</option>
                                    <!--<option value="metro">Metro</option>-->
                                    <!--<option value="minima">Minima</option>-->
                                </select>
							</div>
						</div>
						<!-- Purchase Code -->
						<div class="form-group row">
							<label class="col-xxl-3 col-from-label fs-13">{{translate('Código de compra')}} <span class="text-danger">*</span></label>
							<div class="col-xxl-9">
								<input type="text" class="form-control" name="purchase_key" placeholder="{{ translate('Código de compra CodeCanyon') }}" required>
							</div>
						</div>
						<!-- Domain Name -->
						<div class="form-group row">
							<label class="col-xxl-3 col-from-label fs-13">{{translate('Nome de domínio')}} <span class="text-danger">*</span></label>
							<div class="col-xxl-9">
								<input type="text" class="form-control" name="domain" value="{{ request()->getHost() }}" placeholder="{{ translate('Nome de domínio (exemplo: abcd.com)') }}" required>
							</div>
						</div>
						<!-- Main Site URL -->
						<div class="form-group row">
							<label class="col-xxl-3 col-from-label fs-13">{{translate('URL do site')}} <span class="text-danger">*</span></label>
							<div class="col-xxl-9">
								<input type="text" class="form-control" name="main_url" value="{{ URL::to('/') }}" placeholder="{{ translate('URL do site (exemplo: https://www.abcd.com ou https://abcd.com)') }}" required>
							</div>
						</div>
						<!-- Submit button -->
						<div class="d-flex justify-content-end mt-4">
							<button type="submit" class="btn btn-install mt-3">
								<i class="las la-2x la-cloud-upload-alt mr-3"></i>
								{{ translate('Importar') }}
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
@endsection
