@extends("backend.layouts.app")
@section("content")
<div class="row">
    <div class="col-lg-10 mx-auto">
        <form id="add_form" class="form-horizontal"
            action="{{ route('equipe.update', $itemnew->id) }}" method="POST"
            enctype="multipart/form-data">
            @csrf
            @method('PATCH')
            <div class="form-body">
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção titulo</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" name="show_section_1"
                                    checked value="1">
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} (600x616px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="image" class="selected-files" value="{{ $itemnew->image ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Nome</label>
                                <input class="form-control" type="text" name="title" value="{{ $itemnew->title ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Profissão</label>
                                <input class="form-control" type="text" name="subtitle" value="{{ $itemnew->subtitle ?? '' }}" />
                            </div>
                            <div class="col-lg-6">
                                <label class="col-form-label">CRM</label>
                                <input class="form-control" type="text" name="crm" value="{{ $itemnew->crm ?? '' }}" />
                            </div>
                            <div class="col-lg-6">
                                <label class="col-form-label">RQE</label>
                                <input class="form-control" type="text" name="rqe" value="{{ $itemnew->rqe ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção Card</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_3">
                                <input type="checkbox" name="show_section_3" value="1" {{ isset ($item->show_section_3) && $item->show_section_3 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} (600x616px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_3_img_6">
                                        <input type="hidden" name="section_3_img_6" class="selected-files" value="{{ $item->section_3_img_6 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_3_image_alt_6">
                                <input class="form-control" type="text" name="section_3_image_alt_6" value="{{ $item->section_3_image_alt_6 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_7">
                                <input class="form-control" type="text" name="section_3_conteudo_7" value="{{ $item->section_3_conteudo_7 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_8">
                                <input class="form-control" type="text" name="section_3_conteudo_8" value="{{ $item->section_3_conteudo_8 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_9">
                                <input class="form-control" type="text" name="section_3_conteudo_9" value="{{ $item->section_3_conteudo_9 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_10">
                                <input class="form-control" type="text" name="section_3_conteudo_10" value="{{ $item->section_3_conteudo_10 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção Habilidades Profissionais</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_prof">
                                <input type="checkbox" name="show_section_prof" value="1" {{ isset ($item->show_section_prof) && $item->show_section_prof == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_14">
                                <input class="form-control" type="text" name="section_4_conteudo_14" value="{{ $item->section_4_conteudo_14 ?? '' }}" />
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>habilidades profissionais</label>
                                    @php
                                    $indice = 0;
                                    @endphp
                                    <input type="hidden" name="types[]" value="prof">
                                    <div class="prof-target">
                                        @if(isset($item->prof) && $item->prof != null && $item->prof != 'null')
                                        @foreach(json_decode($item->prof, true) as $key => $value)
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label>Título</label>
                                                        <input type="text" class="form-control" name="prof[{{ $key }}][titulo]"
                                                            value="{{ $value['titulo'] }}">
                                                    </div>
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        @php
                                        $indice++;
                                        @endphp
                                        @endforeach
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                                        data-toggle="add-more"
                                        data-content='
                                            <div class="card shadow-lg">
                                                <div class="row card-body">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>Título</label>
                                                            <input type="text" class="form-control" name="prof[][titulo]">
                                                        </div>
                                                    </div>
                                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                            <i class="las la-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            '
                                        data-target=".prof-target" data-indice="{{ $indice }}">
                                        {{ translate('Add New') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção Informações Pessoais</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_4">
                                <input type="checkbox" name="show_section_4" value="1" {{ isset ($item->show_section_4) && $item->show_section_4 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_4_textarea_11">
                                <textarea name="section_4_textarea_11" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_4_textarea_11 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_12">
                                <input class="form-control" type="text" name="section_4_conteudo_12" value="{{ $item->section_4_conteudo_12 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_13">
                                <input class="form-control" type="text" name="section_4_conteudo_13" value="{{ $item->section_4_conteudo_13 ?? '' }}" />
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Prêmios</label>
                                    @php
                                    $indice = 0;
                                    @endphp
                                    <input type="hidden" name="types[]" value="premios">
                                    <div class="premios-target">
                                        @if(isset($item->premios) && $item->premios != null && $item->premios != 'null')
                                        @foreach(json_decode($item->premios, true) as $key => $value)
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label>{{ translate("Image") }} </label>
                                                        <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                            </div>
                                                            <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                            <input type="hidden" name="premios[{{ $key }}][image]" class="selected-files" value="{{ $value['image'] }}">
                                                        </div>
                                                        <div class="file-preview box"></div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-sm-12">
                                                    <label class="col-form-label">Legenda</label>
                                                    <input class="form-control" type="text" name="premios[{{ $key }}][legenda]" value="{{ $value['legenda'] }}" />
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        @php
                                        $indice++;
                                        @endphp
                                        @endforeach
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
                                        data-toggle="add-more"
                                        data-content='
                                            <div class="card shadow-lg">
                                                <div class="row card-body">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label>{{ translate("Image") }} </label>
                                                            <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                                                </div>
                                                                <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                                                <input type="hidden" name="premios[][image]" class="selected-files">
                                                            </div>
                                                            <div class="file-preview box"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-sm-12">
                                                        <label class="col-form-label">Legenda</label>
                                                        <input class="form-control" type="text" name="premios[][legenda]" />
                                                    </div>
                                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                            <i class="las la-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            '
                                        data-target=".premios-target" data-indice="{{ $indice }}">
                                        {{ translate('Add New') }}
                                    </button>
                                </div>
                            </div>
                            
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção CTA</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_5">
                                <input type="checkbox" name="show_section_5" value="1" {{ isset ($item->show_section_5) && $item->show_section_5 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate("Image") }} </label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate("Browse") }}</div>
                                        </div>
                                        <div class="form-control file-amount">{{ translate("Choose File") }}</div>
                                        <input type="hidden" name="types[]" value="section_4_img_15">
                                        <input type="hidden" name="section_4_img_15" class="selected-files" value="{{ $item->section_4_img_15 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_4_image_alt_15">
                                <input class="form-control" type="text" name="section_4_image_alt_15" value="{{ $item->section_4_image_alt_15 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_16">
                                <input class="form-control" type="text" name="section_4_conteudo_16" value="{{ $item->section_4_conteudo_16 ?? '' }}" />
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_17">
                                <input class="form-control" type="text" name="section_4_conteudo_17" value="{{ $item->section_4_conteudo_17 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_4_link_conteudo_18">
                                <input class="form-control" type="text" name="section_4_link_conteudo_18" value="{{ $item->section_4_link_conteudo_18 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_4_link_18">
                                <input class="form-control" type="text" name="section_4_link_18" value="{{ $item->section_4_link_18 ?? '' }}" />
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_4_link_alt_18">
                                <input class="form-control" type="text" name="section_4_link_alt_18" value="{{ $item->section_4_link_alt_18 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
            <div class="card shadow-lg">
                <div class="card-body">
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">Slug</label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="slug" value="{{ $itemnew->slug ?? '' }}" placeholder="Slug">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label
                            class="col-md-3 col-form-label">{{ translate('Meta Title') }}</label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="meta_title" value="{{ $itemnew->meta_title ?? '' }}" placeholder="{{ translate('Meta Title') }}">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label
                            class="col-md-3 col-form-label">{{ translate('Meta Description') }}</label>
                        <div class="col-md-9">
                            <textarea name="meta_description" rows="5" class="form-control">{{ $itemnew->meta_description ?? '' }}</textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">
                            {{ translate('Meta Keywords') }}
                        </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control"
                                id="meta_keywords" name="meta_keywords"
                                value="{{ $itemnew->meta_keywords ?? '' }}"
                                placeholder="{{ translate('Meta Keywords') }}">
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">
                            {{ translate('Salvar') }}
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('script')
<script>
    function makeSlug(val) {
        let output = val.replace(/\s+/g, "-").toLowerCase();
        $("#slug").val(output);
    }
    $(document).ready(function() {
        $(document).on("click", ".add-new-button", function() {
            $(".aiz-text-editor").each(function() {
                AIZ.plugins.textEditor($(this));
            });
        });
        AIZ.plugins.bootstrapSelect("refresh");
    });
</script>
@endsection
{{--<div class="col-md-12">
    <div class="form-group">
        <label>Comentários</label>
@php
            $indice = 0;
@endphp
        <div class="section_8_conteudo_61-target">
@if($item->section_8_conteudo_61 != null && $item->section_8_conteudo_61 != 'null')
@foreach(json_decode($item->section_8_conteudo_61, true) as $key => $value)
                    <div class="card shadow-lg">
                        <div class="row card-body">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ translate('Image') }}</label>
<div class="input-group" data-toggle="aizuploader" data-type="image">
    <div class="input-group-prepend">
        <div class="input-group-text bg-soft-secondary font-weight-medium">
            {{ translate('Browse') }}
        </div>
    </div>
    <div class="form-control file-amount">{{ translate('Choose File') }}</div>
    <input type="hidden" name="coment[{{ $key }}][imagem]"
        class="selected-files" value="{{ $value['imagem'] }}">
</div>
<div class="file-preview box"></div>
</div>
</div>
<div class="col-md-6">
    <div class="form-group">
        <label>Legenda</label>
        <input type="text" class="form-control"
            name="coment[{{ $key }}][legenda]" value="{{ $value['legenda'] }}">
    </div>
</div>
<div class="col-md-12">
    <div class="form-group">
        <label>Título</label>
        <input type="text" class="form-control"
            name="coment[{{ $key }}][titulo]" value="{{ $value['titulo'] }}">
    </div>
</div>
<div class="col-md-12">
    <div class="form-group">
        <label>Texto corrido</label>
        <textarea name="coment[{{ $key }}][corrido]" class="form-control"
            data-min-height="300" cols="30"
            rows="5">{{ $value['corrido'] }}</textarea>
    </div>
</div>
<button type="button"
    class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo"
    data-toggle="remove-parent" data-parent=".card">
    <i class="las la-times"></i>
</button>
</div>
</div>
@php
$indice++;
@endphp
@endforeach
@endif
</div>
<button type="button"
    class="btn btn-soft-secondary btn-sm add-new-button add-new-button"
    data-toggle="add-more" data-content='
            <div class="card shadow-lg">
                <div class="row card-body">
                        <div class="col-md-6">
                <div class="form-group">
                    <label>{{ translate('Image') }}</label>
                    <div class="input-group" data-toggle="aizuploader" data-type="image">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">
                                {{ translate('Browse') }}</div>
                        </div>
                        <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                        <input type="hidden" name="coment[][imagem]" class="selected-files">
                    </div>
                    <div class="file-preview box"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Legenda</label>
                    <input type="text" class="form-control" name="coment[][legenda]">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label>Título</label>
                    <input type="text" class="form-control" name="coment[][titulo]">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label>Texto corrido</label>
                    <textarea name="coment[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                </div>
            </div>
                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                            <i class="las la-times"></i>
                    </button>
                </div>
            </div>
            ' data-target=".section_8_conteudo_61-target"
    data-indice="{{ $indice }}">
    {{ translate('Add New') }}
</button>
</div>
</div> --}}
