@extends("backend.layouts.app")
@section("content")
<div class="row">
    <div class="col-lg-10 mx-auto">
        <form id="add_form" class="form-horizontal" action="{{ route('segurancaall.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-body">
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 1</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_1">
                                <input type="checkbox" name="show_section_1" value="1" {{ isset($item->show_section_1) && $item->show_section_1 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="col-form-label">Slide</label>
                                    @php
                                    $indice = 0;
                                    @endphp
                                    <input type="hidden" name="types[]" value="slide">
                                    <div class="slide-target">
                                        @if(isset($item->slide) && $item->slide != null && $item->slide != 'null')
                                        @foreach(json_decode($item->slide, true) as $key => $value)
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Imagem</label>
                                                        <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                                            </div>
                                                            <div class="form-control file-amount">Escolha arquivo</div>
                                                            <input type="hidden" class="selected-files" name="slide[{{ $key }}][imag]" value="{{ $value['imag'] }}">
                                                        </div>
                                                        <div class="file-preview box"></div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Título</label>
                                                        <input type="text" class="form-control" name="slide[{{ $key }}][titulo]" value="{{ $value['titulo'] }}">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Texto corrido</label>
                                                        <textarea name="slide[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="col-form-label">Texto do Botão</label>
                                                    <input class="form-control" type="text" name="slide[{{ $key }}][bot]" value="{{ $value['bot'] }}">
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="col-form-label">Link do Botão</label>
                                                    <input class="form-control" type="text" name="slide[{{ $key }}][link]" value="{{ $value['link'] }}">
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="col-form-label">Legenda SEO</label>
                                                    <input class="form-control" type="text" name="slide[{{ $key }}][seo]" value="{{ $value['seo'] }}">
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        @php
                                        $indice++;
                                        @endphp
                                        @endforeach
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button" data-toggle="add-more" data-content=' <div class="card shadow-lg">
                                  <div class="row card-body">
                                    <div class="col-md-6">
                                          <div class="form-group">
                                              <label class="col-form-label">Imagem</label>
                                              <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                  <div class="input-group-prepend">
                                                      <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                                  </div>
                                                  <div class="form-control file-amount">Escolha arquivo</div>
                                                  <input type="hidden" class="selected-files" name="slide[][imag]">
                                              </div>
                                              <div class="file-preview box"></div>
                                          </div>
                                      </div>
                                      <div class="col-lg-12">
                                          <div class="form-group">
                                              <label class="col-form-label">Título</label>
                                              <input type="text" class="form-control" name="slide[][titulo]">
                                          </div>
                                      </div>
                                      <div class="col-lg-12">
                                          <div class="form-group">
                                              <label class="col-form-label">Texto corrido</label>
                                              <textarea name="slide[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                                          </div>
                                      </div>
                                      <div class="col-lg-4">
                                          <label class="col-form-label">Texto do Botão</label>
                                          <input class="form-control" type="text" name="slide[][bot]">
                                      </div>
                                      <div class="col-lg-4">
                                          <label class="col-form-label">Link do Botão</label>
                                          <input class="form-control" type="text" name="slide[][link]">
                                      </div>
                                      <div class="col-lg-4">
                                          <label class="col-form-label">Legenda SEO</label>
                                          <input class="form-control" type="text" name="slide[][seo]">
                                      </div>
                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                      <i class="las la-times"></i>
                                    </button>
                                  </div>
                              </div>
                              ' data-target=".slide-target" data-indice="{{ $indice }}">
                                        {{ translate('Adicionar') }}
                                    </button>
                                </div>
                            </div>

                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 2</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_2">
                                <input type="checkbox" name="show_section_2" value="1" {{ isset($item->show_section_2) && $item->show_section_2 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (40x40px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_2_img_2">
                                        <input type="hidden" name="section_2_img_2" class="selected-files" value="{{ $item->section_2_img_2 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_2_image_alt_2">
                                <input class="form-control" type="text" name="section_2_image_alt_2" value="{{ $item->section_2_image_alt_2 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_2_conteudo_3">
                                <input class="form-control" type="text" name="section_2_conteudo_3" value="{{ $item->section_2_conteudo_3 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_2_conteudo_4">
                                <input class="form-control" type="text" name="section_2_conteudo_4" value="{{ $item->section_2_conteudo_4 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (40x40px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_2_img_5">
                                        <input type="hidden" name="section_2_img_5" class="selected-files" value="{{ $item->section_2_img_5 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_2_image_alt_5">
                                <input class="form-control" type="text" name="section_2_image_alt_5" value="{{ $item->section_2_image_alt_5 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_2_conteudo_6">
                                <input class="form-control" type="text" name="section_2_conteudo_6" value="{{ $item->section_2_conteudo_6 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_2_conteudo_7">
                                <input class="form-control" type="text" name="section_2_conteudo_7" value="{{ $item->section_2_conteudo_7 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_2_link_conteudo_8">
                                <input class="form-control" type="text" name="section_2_link_conteudo_8" value="{{ $item->section_2_link_conteudo_8 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_2_link_8">
                                <input class="form-control" type="text" name="section_2_link_8" value="{{ $item->section_2_link_8 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_2_link_alt_8">
                                <input class="form-control" type="text" name="section_2_link_alt_8" value="{{ $item->section_2_link_alt_8 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 3</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_3">
                                <input type="checkbox" name="show_section_3" value="1" {{ isset($item->show_section_3) && $item->show_section_3 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (407x389px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_3_img_9">
                                        <input type="hidden" name="section_3_img_9" class="selected-files" value="{{ $item->section_3_img_9 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_3_image_alt_9">
                                <input class="form-control" type="text" name="section_3_image_alt_9" value="{{ $item->section_3_image_alt_9 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_10">
                                <input class="form-control" type="text" name="section_3_conteudo_10" value="{{ $item->section_3_conteudo_10 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_11">
                                <input class="form-control" type="text" name="section_3_conteudo_11" value="{{ $item->section_3_conteudo_11 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_3_textarea_12">
                                <textarea name="section_3_textarea_12" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_3_textarea_12 ?? '' }}</textarea>
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_13">
                                <input class="form-control" type="text" name="section_3_conteudo_13" value="{{ $item->section_3_conteudo_13 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_14">
                                <input class="form-control" type="text" name="section_3_conteudo_14" value="{{ $item->section_3_conteudo_14 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_15">
                                <input class="form-control" type="text" name="section_3_conteudo_15" value="{{ $item->section_3_conteudo_15 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_3_conteudo_16">
                                <input class="form-control" type="text" name="section_3_conteudo_16" value="{{ $item->section_3_conteudo_16 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_3_link_conteudo_17">
                                <input class="form-control" type="text" name="section_3_link_conteudo_17" value="{{ $item->section_3_link_conteudo_17 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_3_link_17">
                                <input class="form-control" type="text" name="section_3_link_17" value="{{ $item->section_3_link_17 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_3_link_alt_17">
                                <input class="form-control" type="text" name="section_3_link_alt_17" value="{{ $item->section_3_link_alt_17 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 4</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_4">
                                <input type="checkbox" name="show_section_4" value="1" {{ isset($item->show_section_4) && $item->show_section_4 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_18">
                                <input class="form-control" type="text" name="section_4_conteudo_18" value="{{ $item->section_4_conteudo_18 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_19">
                                <input class="form-control" type="text" name="section_4_conteudo_19" value="{{ $item->section_4_conteudo_19 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_20">
                                <input class="form-control" type="text" name="section_4_conteudo_20" value="{{ $item->section_4_conteudo_20 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="col-form-label">cards</label>
                                    @php
                                    $indice = 0;
                                    @endphp
                                    <input type="hidden" name="types[]" value="cards">
                                    <div class="cards-target">
                                        @if(isset($item->cards) && $item->cards != null && $item->cards != 'null')
                                        @foreach(json_decode($item->cards, true) as $key => $value)
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Imagem (48x49px)</label>
                                                        <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                                            </div>
                                                            <div class="form-control file-amount">Escolha arquivo</div>
                                                            <input type="hidden" class="selected-files" name="cards[{{ $key }}][imag]" value="{{ $value['imag'] }}">
                                                        </div>
                                                        <div class="file-preview box"></div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Título</label>
                                                        <input type="text" class="form-control" name="cards[{{ $key }}][titulo]" value="{{ $value['titulo'] }}">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Texto corrido</label>
                                                        <textarea name="cards[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
                                                    </div>
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        @php
                                        $indice++;
                                        @endphp
                                        @endforeach
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button" data-toggle="add-more" data-content=' <div class="card shadow-lg">
                                                <div class="row card-body">
                                                <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Imagem (48x49px)</label>
                                                            <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                                                </div>
                                                                <div class="form-control file-amount">Escolha arquivo</div>
                                                                <input type="hidden" class="selected-files" name="cards[][imag]">
                                                            </div>
                                                            <div class="file-preview box"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Título</label>
                                                            <input type="text" class="form-control" name="cards[][titulo]">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-12">
                                                        <div class="form-group">
                                                            <label class="col-form-label">Texto corrido</label>
                                                            <textarea name="cards[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                                                        </div>
                                                    </div>
                                                    
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                                </div>
                                            </div>
                                            ' data-target=".cards-target" data-indice="{{ $indice }}">
                                        {{ translate('Adicionar') }}
                                    </button>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_33">
                                <input class="form-control" type="text" name="section_4_conteudo_33" value="{{ $item->section_4_conteudo_33 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_4_link_conteudo_34">
                                <input class="form-control" type="text" name="section_4_link_conteudo_34" value="{{ $item->section_4_link_conteudo_34 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_4_link_34">
                                <input class="form-control" type="text" name="section_4_link_34" value="{{ $item->section_4_link_34 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_4_link_alt_34">
                                <input class="form-control" type="text" name="section_4_link_alt_34" value="{{ $item->section_4_link_alt_34 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (1920x1080px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_4_img_35">
                                        <input type="hidden" name="section_4_img_35" class="selected-files" value="{{ $item->section_4_img_35 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_4_image_alt_35">
                                <input class="form-control" type="text" name="section_4_image_alt_35" value="{{ $item->section_4_image_alt_35 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_36">
                                <input class="form-control" type="text" name="section_4_conteudo_36" value="{{ $item->section_4_conteudo_36 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_37">
                                <input class="form-control" type="text" name="section_4_conteudo_37" value="{{ $item->section_4_conteudo_37 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Texto do Botão</label>
                                <input type="hidden" name="types[]" value="section_4_link_conteudo_38">
                                <input class="form-control" type="text" name="section_4_link_conteudo_38" value="{{ $item->section_4_link_conteudo_38 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Link do Botão</label>
                                <input type="hidden" name="types[]" value="section_4_link_38">
                                <input class="form-control" type="text" name="section_4_link_38" value="{{ $item->section_4_link_38 ?? '' }}" />
                            </div>
                            <div class="col-lg-4">
                                <label class="col-form-label">Legenda SEO</label>
                                <input type="hidden" name="types[]" value="section_4_link_alt_38">
                                <input class="form-control" type="text" name="section_4_link_alt_38" value="{{ $item->section_4_link_alt_38 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_39">
                                <input class="form-control" type="text" name="section_4_conteudo_39" value="{{ $item->section_4_conteudo_39 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_40">
                                <input class="form-control" type="text" name="section_4_conteudo_40" value="{{ $item->section_4_conteudo_40 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_41">
                                <input class="form-control" type="text" name="section_4_conteudo_41" value="{{ $item->section_4_conteudo_41 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_42">
                                <input class="form-control" type="text" name="section_4_conteudo_42" value="{{ $item->section_4_conteudo_42 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_43">
                                <input class="form-control" type="text" name="section_4_conteudo_43" value="{{ $item->section_4_conteudo_43 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_44">
                                <input class="form-control" type="text" name="section_4_conteudo_44" value="{{ $item->section_4_conteudo_44 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_45">
                                <input class="form-control" type="text" name="section_4_conteudo_45" value="{{ $item->section_4_conteudo_45 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_46">
                                <input class="form-control" type="text" name="section_4_conteudo_46" value="{{ $item->section_4_conteudo_46 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_47">
                                <input class="form-control" type="text" name="section_4_conteudo_47" value="{{ $item->section_4_conteudo_47 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_48">
                                <input class="form-control" type="text" name="section_4_conteudo_48" value="{{ $item->section_4_conteudo_48 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_49">
                                <input class="form-control" type="text" name="section_4_conteudo_49" value="{{ $item->section_4_conteudo_49 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_50">
                                <input class="form-control" type="text" name="section_4_conteudo_50" value="{{ $item->section_4_conteudo_50 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_51">
                                <input class="form-control" type="text" name="section_4_conteudo_51" value="{{ $item->section_4_conteudo_51 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_52">
                                <input class="form-control" type="text" name="section_4_conteudo_52" value="{{ $item->section_4_conteudo_52 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_53">
                                <input class="form-control" type="text" name="section_4_conteudo_53" value="{{ $item->section_4_conteudo_53 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_4_conteudo_54">
                                <input class="form-control" type="text" name="section_4_conteudo_54" value="{{ $item->section_4_conteudo_54 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 5</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_5">
                                <input type="checkbox" name="show_section_5" value="1" {{ isset($item->show_section_5) && $item->show_section_5 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_55">
                                <input class="form-control" type="text" name="section_5_conteudo_55" value="{{ $item->section_5_conteudo_55 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_56">
                                <input class="form-control" type="text" name="section_5_conteudo_56" value="{{ $item->section_5_conteudo_56 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_57">
                                <input class="form-control" type="text" name="section_5_conteudo_57" value="{{ $item->section_5_conteudo_57 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (48x49px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_5_img_58">
                                        <input type="hidden" name="section_5_img_58" class="selected-files" value="{{ $item->section_5_img_58 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_58">
                                <input class="form-control" type="text" name="section_5_image_alt_58" value="{{ $item->section_5_image_alt_58 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_59">
                                <input class="form-control" type="text" name="section_5_conteudo_59" value="{{ $item->section_5_conteudo_59 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_60">
                                <input class="form-control" type="text" name="section_5_conteudo_60" value="{{ $item->section_5_conteudo_60 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (47x48px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_5_img_61">
                                        <input type="hidden" name="section_5_img_61" class="selected-files" value="{{ $item->section_5_img_61 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_61">
                                <input class="form-control" type="text" name="section_5_image_alt_61" value="{{ $item->section_5_image_alt_61 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_62">
                                <input class="form-control" type="text" name="section_5_conteudo_62" value="{{ $item->section_5_conteudo_62 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_63">
                                <input class="form-control" type="text" name="section_5_conteudo_63" value="{{ $item->section_5_conteudo_63 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (47x48px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_5_img_64">
                                        <input type="hidden" name="section_5_img_64" class="selected-files" value="{{ $item->section_5_img_64 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_64">
                                <input class="form-control" type="text" name="section_5_image_alt_64" value="{{ $item->section_5_image_alt_64 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_65">
                                <input class="form-control" type="text" name="section_5_conteudo_65" value="{{ $item->section_5_conteudo_65 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_66">
                                <input class="form-control" type="text" name="section_5_conteudo_66" value="{{ $item->section_5_conteudo_66 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (439x429px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_5_img_67">
                                        <input type="hidden" name="section_5_img_67" class="selected-files" value="{{ $item->section_5_img_67 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_67">
                                <input class="form-control" type="text" name="section_5_image_alt_67" value="{{ $item->section_5_image_alt_67 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (48x48px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_5_img_68">
                                        <input type="hidden" name="section_5_img_68" class="selected-files" value="{{ $item->section_5_img_68 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_68">
                                <input class="form-control" type="text" name="section_5_image_alt_68" value="{{ $item->section_5_image_alt_68 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_69">
                                <input class="form-control" type="text" name="section_5_conteudo_69" value="{{ $item->section_5_conteudo_69 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_70">
                                <input class="form-control" type="text" name="section_5_conteudo_70" value="{{ $item->section_5_conteudo_70 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (48x48px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_5_img_71">
                                        <input type="hidden" name="section_5_img_71" class="selected-files" value="{{ $item->section_5_img_71 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_71">
                                <input class="form-control" type="text" name="section_5_image_alt_71" value="{{ $item->section_5_image_alt_71 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_72">
                                <input class="form-control" type="text" name="section_5_conteudo_72" value="{{ $item->section_5_conteudo_72 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_73">
                                <input class="form-control" type="text" name="section_5_conteudo_73" value="{{ $item->section_5_conteudo_73 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (48x48px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_5_img_74">
                                        <input type="hidden" name="section_5_img_74" class="selected-files" value="{{ $item->section_5_img_74 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_5_image_alt_74">
                                <input class="form-control" type="text" name="section_5_image_alt_74" value="{{ $item->section_5_image_alt_74 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_75">
                                <input class="form-control" type="text" name="section_5_conteudo_75" value="{{ $item->section_5_conteudo_75 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_5_conteudo_76">
                                <input class="form-control" type="text" name="section_5_conteudo_76" value="{{ $item->section_5_conteudo_76 ?? '' }}" />
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 6</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_6">
                                <input type="checkbox" name="show_section_6" value="1" {{ isset($item->show_section_6) && $item->show_section_6 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (611x651px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_6_img_77">
                                        <input type="hidden" name="section_6_img_77" class="selected-files" value="{{ $item->section_6_img_77 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_77">
                                <input class="form-control" type="text" name="section_6_image_alt_77" value="{{ $item->section_6_image_alt_77 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_78">
                                <input class="form-control" type="text" name="section_6_conteudo_78" value="{{ $item->section_6_conteudo_78 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_79">
                                <input class="form-control" type="text" name="section_6_conteudo_79" value="{{ $item->section_6_conteudo_79 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_6_textarea_80">
                                <textarea name="section_6_textarea_80" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_6_textarea_80 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (40x40px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_6_img_81">
                                        <input type="hidden" name="section_6_img_81" class="selected-files" value="{{ $item->section_6_img_81 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_81">
                                <input class="form-control" type="text" name="section_6_image_alt_81" value="{{ $item->section_6_image_alt_81 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_82">
                                <input class="form-control" type="text" name="section_6_conteudo_82" value="{{ $item->section_6_conteudo_82 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_6_textarea_83">
                                <textarea name="section_6_textarea_83" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_6_textarea_83 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (41x41px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_6_img_84">
                                        <input type="hidden" name="section_6_img_84" class="selected-files" value="{{ $item->section_6_img_84 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_84">
                                <input class="form-control" type="text" name="section_6_image_alt_84" value="{{ $item->section_6_image_alt_84 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_85">
                                <input class="form-control" type="text" name="section_6_conteudo_85" value="{{ $item->section_6_conteudo_85 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_6_textarea_86">
                                <textarea name="section_6_textarea_86" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_6_textarea_86 ?? '' }}</textarea>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (40x41px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_6_img_87">
                                        <input type="hidden" name="section_6_img_87" class="selected-files" value="{{ $item->section_6_img_87 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_6_image_alt_87">
                                <input class="form-control" type="text" name="section_6_image_alt_87" value="{{ $item->section_6_image_alt_87 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_6_conteudo_88">
                                <input class="form-control" type="text" name="section_6_conteudo_88" value="{{ $item->section_6_conteudo_88 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Texto corrido</label>
                                <input type="hidden" name="types[]" value="section_6_textarea_89">
                                <textarea name="section_6_textarea_89" class="aiz-text-editor" data-min-height="300" cols="30" rows="10">{{ $item->section_6_textarea_89 ?? '' }}</textarea>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card shadow-lg">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Seção 7</h4>
                        <div class="d-flex align-items-center">
                            <label class="mr-2">Mostrar seção?</label>
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="hidden" name="types[]" value="show_section_7">
                                <input type="checkbox" name="show_section_7" value="1" {{ isset($item->show_section_7) && $item->show_section_7 == '1' ? 'checked' : '' }}>
                                <span></span>
                            </label>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_90">
                                <input class="form-control" type="text" name="section_7_conteudo_90" value="{{ $item->section_7_conteudo_90 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_91">
                                <input class="form-control" type="text" name="section_7_conteudo_91" value="{{ $item->section_7_conteudo_91 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_92">
                                <input class="form-control" type="text" name="section_7_conteudo_92" value="{{ $item->section_7_conteudo_92 ?? '' }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Imagem (416x459px)</label>
                                    <div class="input-group" data-toggle="aizuploader" data-type="image,video">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text bg-soft-secondary font-weight-medium">Navegar</div>
                                        </div>
                                        <div class="form-control file-amount">Escolha arquivo</div>
                                        <input type="hidden" name="types[]" value="section_7_img_93">
                                        <input type="hidden" name="section_7_img_93" class="selected-files" value="{{ $item->section_7_img_93 ?? '' }}">
                                    </div>
                                    <div class="file-preview box"></div>
                                </div>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label class="col-form-label">Legenda</label>
                                <input type="hidden" name="types[]" value="section_7_image_alt_93">
                                <input class="form-control" type="text" name="section_7_image_alt_93" value="{{ $item->section_7_image_alt_93 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_94">
                                <input class="form-control" type="text" name="section_7_conteudo_94" value="{{ $item->section_7_conteudo_94 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_95">
                                <input class="form-control" type="text" name="section_7_conteudo_95" value="{{ $item->section_7_conteudo_95 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_96">
                                <input class="form-control" type="text" name="section_7_conteudo_96" value="{{ $item->section_7_conteudo_96 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <label class="col-form-label">Título</label>
                                <input type="hidden" name="types[]" value="section_7_conteudo_97">
                                <input class="form-control" type="text" name="section_7_conteudo_97" value="{{ $item->section_7_conteudo_97 ?? '' }}" />
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="col-form-label">Comentários</label>
                                    @php
                                    $indice = 0;
                                    @endphp
                                    <input type="hidden" name="types[]" value="coment">
                                    <div class="coment-target">
                                        @if(isset($item->coment) && $item->coment != null && $item->coment != 'null')
                                        @foreach(json_decode($item->coment, true) as $key => $value)
                                        <div class="card shadow-lg">
                                            <div class="row card-body">
                                                <div class="col-lg-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Título</label>
                                                        <input type="text" class="form-control" name="coment[{{ $key }}][titulo]" value="{{ $value['titulo'] }}">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-group">
                                                        <label class="col-form-label">Texto corrido</label>
                                                        <textarea name="coment[{{ $key }}][corrido]" class="form-control" data-min-height="300" cols="30" rows="5">{{ $value['corrido'] }}</textarea>
                                                    </div>
                                                </div>
                                                <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                                    <i class="las la-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                        @php
                                        $indice++;
                                        @endphp
                                        @endforeach
                                        @endif
                                    </div>
                                    <button type="button" class="btn btn-soft-secondary btn-sm add-new-button add-new-button" data-toggle="add-more" data-content=' <div class="card shadow-lg">
                                  <div class="row card-body">
                                    <div class="col-lg-12">
                                      <div class="form-group">
                                        <label class="col-form-label">Título</label>
                                        <input type="text" class="form-control" name="coment[][titulo]">
                                      </div>
                                    </div>
                                    <div class="col-lg-12">
                                      <div class="form-group">
                                        <label class="col-form-label">Texto corrido</label>
                                        <textarea name="coment[][corrido]" class="form-control" data-min-height="300" cols="30" rows="5"></textarea>
                                      </div>
                                    </div>
                                    <button type="button" class="mt-1 btn btn-icon btn-circle btn-sm btn-soft-danger ccdo" data-toggle="remove-parent" data-parent=".card">
                                      <i class="las la-times"></i>
                                    </button>
                                  </div>
                              </div>
                              ' data-target=".coment-target" data-indice="{{ $indice }}">
                                        {{ translate('Adicionar') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-primary">
                                {{ translate('Salvar') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card shadow-lg">
                <div class="card-body">
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">{{ translate('Meta Title') }}</label>
                        <div class="col-lg-9">
                            <input type="hidden" name="types[]" value="meta_title">
                            <input type="text" class="form-control" name="meta_title" value="{{ $item->meta_title ?? '' }}" placeholder="{{ translate('Meta Title') }}">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">{{ translate('Meta Description') }}</label>
                        <div class="col-lg-9">
                            <input type="hidden" name="types[]" value="meta_description">
                            <textarea name="meta_description" rows="5" class="form-control">{{ $item->meta_description ?? '' }}</textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">
                            {{ translate('Meta Keywords') }}
                        </label>
                        <div class="col-lg-9">
                            <input type="hidden" name="types[]" value="meta_keywords">
                            <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="{{ $item->meta_keywords ?? '' }}" placeholder="{{ translate('Meta Keywords') }}">
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">
                            {{ translate('Salvar') }}
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('script')
<script>
    function makeSlug(val) {
        let output = val.replace(/\s+/g, "-").toLowerCase();
        $("#slug").val(output);
    }
    $(document).ready(function() {
        $(document).on("click", ".add-new-button", function() {
            $(".aiz-text-editor").each(function() {
                AIZ.plugins.textEditor($(this));
            });
        });
        AIZ.plugins.bootstrapSelect("refresh");
    });

</script>
@endsection

