@extends('backend.layouts.app')
@section('content')
<div class="aiz-titlebar text-left mt-2 mb-3">
	<div class="row align-items-center">
		<div class="col">
			<h1 class="h3">{{ translate('Adicionar nova página') }}</h1>
		</div>
	</div>
</div>
<div class="card">
	<form action="{{ route('custom-pages.store') }}" method="POST" enctype="multipart/form-data">
		@csrf
		<div class="card-header">
			<h6 class="fw-600 mb-0">{{ translate('Conteúdo da página') }}</h6>
		</div>
		<div class="card-body">
			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="name">{{translate('Título')}} <span class="text-danger">*</span></label>
				<div class="col-sm-10">
					<input type="text" class="form-control" placeholder="{{translate('Título')}}" name="title" required>
				</div>
			</div>
			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="name">{{translate('Link')}} <span class="text-danger">*</span></label>
				<div class="col-sm-10">
					<div class="input-group d-block d-md-flex">
						<div class="input-group-prepend "><span class="input-group-text flex-grow-1">{{ route('home') }}/</span></div>
						<input type="text" class="form-control w-100 w-md-auto" placeholder="{{ translate('Slug') }}" name="slug" required>
					</div>
					<small class="form-text text-muted">{{ translate('Use apenas caractere, número e hífen') }}</small>
				</div>
			</div>
			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="name">{{translate('Adicionar conteúdo')}} <span class="text-danger">*</span></label>
				<div class="col-sm-10">
					<textarea
						class="aiz-text-editor form-control"
						data-buttons='[["font", ["bold", "underline", "italic", "clear"]],["para", ["ul", "ol", "paragraph"]],["style", ["style"]],["color", ["color"]],["table", ["table"]],["insert", ["link", "picture", "video"]],["view", ["fullscreen", "codeview", "undo", "redo"]]]'
						placeholder="Content.."
						data-min-height="300"
						name="content"
						required
					></textarea>
				</div>
			</div>
		</div>

		<div class="card-header">
			<h6 class="fw-600 mb-0">{{ translate('Campos de SEO') }}</h6>
		</div>
		<div class="card-body">

			<div class="form-group row">
					<label class="col-sm-2 col-from-label" for="name">{{translate('Metatítulo')}}</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" placeholder="{{translate('Título')}}" name="meta_title">
					</div>
			</div>

			<div class="form-group row">
				<label class="col-sm-2 col-from-label" for="name">{{translate('Meta descrição')}}</label>
				<div class="col-sm-10">
					<textarea class="resize-off form-control" placeholder="{{translate('Descrição')}}" name="meta_description"></textarea>
				</div>
			</div>

			<div class="form-group row">
					<label class="col-sm-2 col-from-label" for="name">{{translate('Palavras-chave')}}</label>
					<div class="col-sm-10">
						<textarea class="resize-off form-control" placeholder="{{translate('Palavra-chave, palavra-chave')}}" name="keywords"></textarea>
						<small class="text-muted">{{ translate('Separar com vírgula') }}</small>
					</div>
			</div>

			<div class="form-group row">
					<label class="col-sm-2 col-from-label" for="name">{{translate('Metaimagem')}}</label>
					<div class="col-sm-10">
						<div class="input-group " data-toggle="aizuploader" data-type="image">
								<div class="input-group-prepend">
										<div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar') }}</div>
								</div>
								<div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
								<input type="hidden" name="meta_image" class="selected-files">
						</div>
						<div class="file-preview">
						</div>
					</div>
			</div>

			<div class="text-right">
				<button type="submit" class="btn btn-primary">{{ translate('Salvar página') }}</button>
			</div>
		</div>
	</form>
</div>
@endsection
