@extends('frontend.layouts.app')

@section('meta_title'){{ $blog->meta_title }}@stop

@section('meta_description'){{ $blog->meta_description }}@stop

@section('meta_keywords'){{ $blog->meta_keywords }}@stop

@section('style')
    <link rel="stylesheet" href="{{ static_asset('assets/css/blog.css') }}">
@endsection

@section('meta')
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ $blog->meta_title }}">
    <meta itemprop="description" content="{{ $blog->meta_description }}">
    <meta itemprop="image" content="{{ uploaded_asset($blog->meta_img) }}">

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:site" content="@publisher_handle">
    <meta name="twitter:title" content="{{ $blog->meta_title }}">
    <meta name="twitter:description" content="{{ $blog->meta_description }}">
    <meta name="twitter:creator" content="@author_handle">
    <meta name="twitter:image" content="{{ uploaded_asset($blog->meta_img) }}">

    <!-- Open Graph data -->
    <meta property="og:title" content="{{ $blog->meta_title }}" />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="{{ route('blog.details', $blog->slug) }}" />
    <meta property="og:image" content="{{ uploaded_asset($blog->meta_img) }}" />
    <meta property="og:description" content="{{ $blog->meta_description }}" />
    <meta property="og:site_name" content="{{ env('APP_NAME') }}" />
@endsection

@section('content')
<div class="wrapper">
    <main class="main-content site-wrapper-reveal bgcolor-gray">
      <section class="blog-details-area">
        <div class="container-fluid p-0 new_image">
          <img class="w-100" src="{{ uploaded_asset($blog->banner) }}" alt="{{ $blog->title }}">
        </div>
        <div class="container pt-0 pb-150 pb-md-80 ">
          <div class="post-details-content post-content-style3 pb-md-50 shadow">
            <div class="row">
              <div class="col-lg-8 m-auto">
                <div class="post-details-body post-body-style2">
                  <div class="content">
                    <div class="bread-crumbs text-theme-color5 lh-1 mb-70 mb-sm-40">
                      <a href="{{route('home')}}">Home /</a> <a href="{{route('blog')}}">Blog </a> 
                    </div>
                    <h2 class="title mb-10 pb-2">{{ $blog->title }}</h2>
                    {!! $blog->description !!}
                  </div>
                </div>
                <div class="related-posts">
                  <h2 class="title">{{ translate('Postagens recentes') }}</h2>
                  <div class="post-items-slider-four row">
                    @foreach($recent_blogs as $recent_blog)
                    <div class="col-lg-6">
                        <div class="post-item card">
                          <div class="thumb">
                            <a href="{{ url("blog").'/'. $recent_blog->slug }}"><img src="{{ uploaded_asset($recent_blog->banner) }}" alt="{{ $recent_blog->title }}"></a>
                          </div>
                          <div class="content">
                            <h4 class="title">
                              <a href="{{ url("blog").'/'. $recent_blog->slug }}">{{ $recent_blog->title }}</a>
                            </h4>
                            <div class="meta bottom">
                              <div>
                                Por
                                <span class="author">{{ get_setting('website_name') }}</span>
                                <span>{{ date('d M Y',strtotime($recent_blog->created_at)) }}</span>
                              </div>
                            </div>
                          </div>
                        </div>
                    </div>
                    @endforeach
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="line-hr"></div>
      </section>
    </main>
  </div>
@endsection


@section('script')
    @if (get_setting('facebook_comment') == 1)
        <div id="fb-root"></div>
        <script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v9.0&appId={{ env('FACEBOOK_APP_ID') }}&autoLogAppEvents=1" nonce="ji6tXwgZ"></script>
    @endif
@endsection