@extends('frontend.layouts.app')

@section('content')
  <!--==============================
    Breadcumb
============================== -->
    <div class="breadcumb-wrapper " data-bg-src="{{ uploaded_asset($blogall->banner ?? '') }}">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-9">
                    <div class="breadcumb-content">
                        <h1 class="breadcumb-title">Blog Post</h1>
                        <ul class="breadcumb-menu">
                            <li><a href="{{route('home')}}">Home</a></li>
                            <li>Blog</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div><!--==============================
Blog Area
==============================-->
    <section class="th-blog-wrapper space-top space-extra-bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-8 col-lg-7">
                    @foreach($blogs as $blog)
                        <div class="th-blog blog-single has-post-thumbnail">
                            <div class="blog-img">
                                <a href="{{ url("blog").'/'. $blog->slug }}"><img src="{{ uploaded_asset($blog->banner) }}" alt="{{ $blog->title }}"></a>
                            </div>
                            <div class="blog-content">
                                <div class="blog-meta">
                                    <a href="{{ url('blog') . '/' . $blog->slug }}" class="text-theme"><i class="far fa-clock text-theme"></i>{{ date('d M Y',strtotime($blog->created_at)) }}</a>
                                    @if($blog->category != null)
                                        <a href="{{ url('blog') .'/'. $blog->slug }}" class="text-theme"><i class="far fa-house-building text-theme"></i>{{ $blog->category->category_name }}</a>
                                    @endif
                                    
                                </div>
                                <h2 class="blog-title"><a href="{{ url('blog') .'/'. $blog->slug }}">{{ $blog->title }}</a></h2>
                                <p class="blog-text">{{ $blog->short_description }}</p>
                                <a href="{{ url("blog").'/'. $blog->slug }}" class="th-btn style-border2 th-btn-icon">{{translate('Leia mais')}}</a>
                            </div>
                        </div>
                    @endforeach
                    <div class="th-pagination">
                        {{ $blogs->links() }}
                    </div>
                </div>
                <div class="col-xxl-4 col-lg-5">
                    <aside class="sidebar-area">
                        <div class="widget widget_search">
                            <form class="search-form" action="{{ route('blog') }}" method="GET">
                                <input type="text" name="search" placeholder="Procurar..." value="{{ request('search') }}">
                            
                                @if(request()->has('selected_categories'))
                                    <input type="hidden" name="selected_categories" value="{{ request('selected_categories') }}">
                                @endif
                        
                                <button type="submit"><i class="far fa-search"></i></button>
                            </form>
                        </div>
                        <div class="widget widget_categories  ">
                            <h3 class="widget_title">{{translate('Categorias')}}</h3>
                            <ul>
                                @foreach($allcategories as $category)
                                    <li>
                                        <a href="{{ route('blog', ['selected_categories' => $category->slug, 'search' => request('search')]) }}">
                                            {{ $category->category_name }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="widget  ">
                            <h3 class="widget_title">{{translate('Blogs Recentes')}}</h3>
                            <div class="recent-post-wrap">
                                @foreach($blogs as $blog)
                                    <div class="recent-post">
                                        <div class="media-img">
                                            <a href="{{ url("blog").'/'. $blog->slug }}"><img src="{{ uploaded_asset($blog->banner) }}" alt="{{ $blog->title }}"></a>
                                        </div>
                                        <div class="media-body">
                                            <h4 class="post-title"><a class="text-inherit" href="{{ url("blog").'/'. $blog->slug }}">{{ $blog->title }}</a></h4>
                                            <div class="recent-post-meta">
                                                <a href="{{ url("blog").'/'. $blog->slug }}"><i class="far fa-calendar"></i>{{ date('d M Y',strtotime($blog->created_at)) }}</a>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="widget widget_banner  " data-bg-src="assets/img/widget/widget-banner.png">
                            <div class="widget-banner text-center">
                                <h3 class="title">{{$blogall->title ?? '' }}</h3>
                                <div class="logo"><img src="{{uploaded_asset($blogall->image ?? '' )}}" alt="img"></div>
                                <h4 class="subtitle">{{$blogall->subtitle ?? '' }}</h4>
                                <h5 class="link"><a href="tel:{{preg_replace('/[^0-9]/', '', $blogall->number ?? '' ) }}">{{$blogall->number ?? '' }}</a></h5>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
    @endsection
