@extends('seller.layouts.app')

@section('panel_content')

<div class="page-content mx-0">
    <div class="aiz-titlebar mt-2 mb-4">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="h3">{{ translate('Adicione seu produto') }}</h1>
            </div>
            <div class="col text-right">
                <a class="btn btn-xs btn-soft-primary" href="javascript:void(0);" onclick="clearTempdata()">
                    {{ translate('Limpar dados temporários') }}
                </a>
            </div>
        </div>
    </div>
    
    <!-- Error Meassages -->
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Data type -->
    <input type="hidden" id="data_type" value="digital">

    <form class="" action="{{route('seller.digitalproducts.store')}}" method="POST" enctype="multipart/form-data" id="choice_form">
        @csrf
		<input type="hidden" name="added_by" value="seller">
		<input type="hidden" name="digital" value="1">


        <div class="row gutters-5">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{translate('Em geral')}}</h5>
                    </div>
        
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{translate('Nome do produto')}} <span class="text-danger">*</span></label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" name="name" placeholder="{{translate('Nome do produto')}}" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{ translate('Arquivo do produto')}}</label>
                            <div class="col-lg-9">
                                <div class="input-group" data-toggle="aizuploader" data-multiple="false">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar')}}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                                    <input type="hidden" name="file_name" class="selected-files">
                                </div>
                                <div class="file-preview box sm">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{translate('Etiquetas')}}</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control aiz-tag-input" name="tags[]" placeholder="{{ translate('Digite e aperte enter') }}">
                                <small class="text-muted">{{translate('Isso é usado para pesquisa. Insira as palavras pelas quais o cliente pode encontrar este produto.')}}</small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{translate('Imagens')}}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-lg-3 col-form-label" for="signinSrEmail">{{translate('Imagens da galeria')}} <small>(600x600)</small></label>
                            <div class="col-lg-9">
                                <div class="input-group" data-toggle="aizuploader" data-type="image" data-multiple="true">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar')}}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                                    <input type="hidden" name="photos" class="selected-files">
                                </div>
                                <div class="file-preview box sm">
                                </div>
                                <small class="text-muted">{{translate('Essas imagens são visíveis na galeria da página de detalhes do produto. Use imagens de tamanhos 600x600.')}}</small>
                            </div>
                        </div>
        
                        <div class="form-group row">
                            <label class="col-lg-3 col-form-label" for="signinSrEmail">{{translate('Imagem em miniatura')}} <small>(300x300)</small></label>
                            <div class="col-lg-9">
                                <div class="input-group" data-toggle="aizuploader" data-type="image" data-multiple="false">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar')}}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                                    <input type="hidden" name="thumbnail_img" class="selected-files">
                                </div>
                                <div class="file-preview box sm">
                                </div>
                                <small class="text-muted">{{translate('Esta imagem é visível em todas as caixas do produto. Use imagens de tamanhos 300x300. Mantenha algum espaço em branco ao redor do objeto principal da sua imagem, pois tivemos que cortar algumas bordas em diferentes dispositivos para torná-la responsiva.')}}</small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{translate('Metatags')}}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{translate('Metatítulo')}}</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" name="meta_title" placeholder="{{translate('Metatítulo')}}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{translate('Descrição')}}</label>
                            <div class="col-lg-9">
                                <textarea name="meta_description" rows="5" class="form-control"></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-3 col-form-label" for="signinSrEmail">{{ translate('Metaimagem') }}</label>
                            <div class="col-lg-9">
                                <div class="input-group" data-toggle="aizuploader" data-type="image" data-multiple="false">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Navegar')}}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Escolha arquivo') }}</div>
                                    <input type="hidden" name="meta_img" class="selected-files">
                                </div>
                                <div class="file-preview box sm">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{translate('Preço')}}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{translate('Preço unitário')}} <span class="text-danger">*</span></label>
                            <div class="col-lg-9">
                                <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="{{translate('Preço unitário')}}" name="unit_price" class="form-control" required>
                            </div>
                        </div>
                        @foreach (\App\Models\Tax::where('tax_status', 1)->get() as $tax)
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{ $tax->name }}</label>
                            <div class="col-lg-6">
                                <input type="hidden" value="{{$tax->id}}" name="tax_id[]">
                                <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="{{translate('Imposto')}}" name="tax[]" class="form-control" required>
                            </div>
                            <div class="col-md-3">
                                <select class="form-control aiz-selectpicker" name="tax_type[]">
                                    <option value="amount">{{translate('Plano')}}</option>
                                    <option value="percent">{{translate('Por cento')}}</option>
                                </select>
                            </div>
                        </div>
                        @endforeach
                        <div class="form-group row">
                            <label class="col-md-3 control-label"
                                for="start_date">{{ translate('Período de desconto') }} </label>
                            <div class="col-md-9">
                                <input type="text" class="form-control aiz-date-range" name="date_range"
                                    placeholder="{{ translate('Selecione a data') }}" data-time-picker="true"
                                    data-format="DD-MM-Y HH:mm:ss" data-separator=" to " autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{translate('Desconto')}} <span class="text-danger">*</span></label>
                            <div class="col-lg-6">
                                <input type="number" lang="en" min="0" value="0" step="0.01" placeholder="{{translate('Desconto')}}" name="discount" class="form-control" required>
                            </div>
                            <div class="col-md-3">
                                <select class="form-control aiz-selectpicker" name="discount_type">
                                    <option value="amount">{{translate('Plano')}}</option>
                                    <option value="percent">{{translate('Por cento')}}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{translate('Informações do produto')}}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-lg-3 col-from-label">{{translate('Descrição')}}</label>
                            <div class="col-lg-9">
                                <textarea class="aiz-text-editor" name="description"></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Frequently Bought Products --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Comprado com frequência') }}</h5>
                    </div>
                    <div class="w-100">
                        <div class="d-flex my-3"> 
                            <div class="align-items-center d-flex mar-btm ml-4 mr-5 radio">
                                <input id="fq_bought_select_products" type="radio" name="frequently_bought_selection_type" value="product" onchange="fq_bought_product_selection_type()" checked >
                                <label for="fq_bought_select_products" class="fs-14 fw-500 mb-0 ml-2">{{translate('Selecione o produto')}}</label>
                            </div>
                            <div class="radio mar-btm mr-3 d-flex align-items-center">
                                <input id="fq_bought_select_category" type="radio" name="frequently_bought_selection_type" value="category" onchange="fq_bought_product_selection_type()">
                                <label for="fq_bought_select_category" class="fs-14 fw-500 mb-0 ml-2">{{translate('Selecione a categoria')}}</label>
                            </div>
                        </div>

                        <div class="px-3 px-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="fq_bought_select_product_div">
    
                                        <div id="selected-fq-bought-products">
    
                                        </div>
    
                                        <button 
                                            type="button" 
                                            class="btn btn-block border border-dashed hov-bg-soft-secondary fs-14 rounded-0 d-flex align-items-center justify-content-center"
                                            onclick="showFqBoughtProductModal()">
                                            <i class="las la-plus"></i>
                                            <span class="ml-2">{{ translate('Adicionar mais') }}</span>
                                        </button>
                                    </div>
    
                                    {{-- Select Category for Frequently Bought Product --}}
                                    <div class="fq_bought_select_category_div d-none">
                                        <div class="form-group row">
                                            <label class="col-md-2 col-from-label">{{translate('Categoria')}}</label>
                                            <div class="col-md-10">
                                                <select class="form-control aiz-selectpicker" data-placeholder="{{ translate('Selecione uma categoria')}}" name="fq_bought_product_category_id" data-live-search="true">
                                                    @foreach ($categories as $category)
                                                        <option value="{{ $category->id }}">{{ $category->getTranslation('name') }}</option>
                                                        @foreach ($category->childrenCategories as $childCategory)
                                                            @include('categories.child_category', ['child_category' => $childCategory])
                                                        @endforeach
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Categoria de produto') }}</h5>
                        <h6 class="float-right fs-13 mb-0">
                            {{ translate('Selecione Principal') }}
                            <span class="position-relative main-category-info-icon">
                                <i class="las la-question-circle fs-18 text-info"></i>
                                <span class="main-category-info bg-soft-info p-2 position-absolute d-none border">{{ translate('Isso será usado para cálculos baseados em comissões e exibição de produtos da categoria da página inicial.') }}</span>
                            </span>
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="h-190px overflow-auto c-scrollbar-light">
                            <ul class="hummingbird-treeview-converter list-unstyled" data-checkbox-name="category_ids[]" data-radio-name="category_id">
                                @foreach ($categories as $category)
                                <li id="{{ $category->id }}">{{ $category->getTranslation('name') }}</li>
                                    @foreach ($category->childrenCategories as $childCategory)
                                        @include('backend.product.products.child_category', ['child_category' => $childCategory])
                                    @endforeach
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group mb-0 text-right mb-2">
            <button type="submit" name="button" value="publish" class="btn btn-primary">{{translate('Salvar produto')}}</button>
        </div>
    </form>
</div>

@endsection

@section('modal')
	<!-- Frequently Bought Product Select Modal -->
    @include('modals.product_select_modal')
@endsection

@section('script')
<!-- Treeview js -->
<script src="{{ static_asset('assets/js/hummingbird-treeview.js') }}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $("#treeview").hummingbird();
    });

    function fq_bought_product_selection_type(){
            var productSelectionType = $("input[name='frequently_bought_selection_type']:checked").val();
            if(productSelectionType == 'product'){
                $('.fq_bought_select_product_div').removeClass('d-none');
                $('.fq_bought_select_category_div').addClass('d-none');
            }
            else if(productSelectionType == 'category'){
                $('.fq_bought_select_category_div').removeClass('d-none');
                $('.fq_bought_select_product_div').addClass('d-none');
            }
        }

        function showFqBoughtProductModal() {
            $('#fq-bought-product-select-modal').modal('show', {backdrop: 'static'});
        }

        function filterFqBoughtProduct() {
            var searchKey = $('input[name=search_keyword]').val();
            var fqBroughCategory = $('select[name=fq_brough_category]').val();
            $.post('{{ route('seller.product.search') }}', { _token: AIZ.data.csrf, product_id: null, search_key:searchKey, category:fqBroughCategory, product_type:"digital" }, function(data){
                $('#product-list').html(data);
                AIZ.plugins.fooTable();
            });
        }

        function addFqBoughtProduct() {
            var selectedProducts = [];
            $("input:checkbox[name=fq_bought_product_id]:checked").each(function() {
                selectedProducts.push($(this).val());
            });

            var fqBoughtProductIds = [];
            $("input[name='fq_bought_product_ids[]']").each(function() {
                fqBoughtProductIds.push($(this).val());
            });

            var productIds = selectedProducts.concat(fqBoughtProductIds.filter((item) => selectedProducts.indexOf(item) < 0))

            $.post('{{ route('seller.get-selected-products') }}', { _token: AIZ.data.csrf, product_ids:productIds}, function(data){
                $('#fq-bought-product-select-modal').modal('hide');
                $('#selected-fq-bought-products').html(data);
                AIZ.plugins.fooTable();
            });
        }
        
</script>

@include('partials.product.product_temp_data')

@endsection