@extends('seller.layouts.app')

@section('panel_content')

    <div class="aiz-titlebar mt-2 mb-4">
      <div class="row align-items-center">
        <div class="col-md-6">
            <h1 class="h3">{{ translate('Upload de produtos em massa') }}</h1>
        </div>
      </div>
    </div>

    <div class="card">
        <div class="card-body">
            <table class="table aiz-table mb-0" style="font-size:14px; background-color: #cce5ff; border-color: #b8daff">
                <tr>
                    <td>{{ translate('1. Baixe o arquivo esqueleto e preencha-o com dados.')}}:</td>
                </tr>
                <tr >
                    <td>{{ translate('2. Você pode baixar o arquivo de exemplo para entender como os dados devem ser preenchidos.')}}:</td>
                </tr>
                <tr>
                    <td>{{ translate('3. Depois de baixar e preencher o arquivo esqueleto, carregue-o no formulário abaixo e envie.')}}:</td>
                </tr>
                <tr>
                    <td>{{ translate('4. Depois de enviar os produtos, você precisa editá-los e definir imagens e opções dos produtos.')}}</td>
                </tr>
            </table>
            <a href="{{ static_asset('download/product_bulk_demo.xlsx') }}" download><button class="btn btn-primary mt-2">{{ translate('Baixar CSV') }}</button></a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <table class="table aiz-table mb-0" style="font-size:14px;background-color: #cce5ff;border-color: #b8daff">
                <tr>
                    <td>{{ translate('1. Categoria e Marca deverão estar em id numérico.')}}:</td>
                </tr>
                <tr >
                    <td>{{ translate('2. Você pode baixar o pdf para obter o ID da categoria e da marca.')}}:</td>
                </tr>
            </table>
            <a href="{{ route('seller.pdf.download_category') }}"><button class="btn btn-primary mt-2">{{ translate('Baixar categoria')}}</button></a>
            <a href="{{ route('seller.pdf.download_brand') }}"><button class="btn btn-primary mt-2">{{ translate('Baixar marca')}}</button></a>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="col text-center text-md-left">
                <h5 class="mb-md-0 h6">{{ translate('Carregar arquivo CSV') }}</h5>
            </div>
        </div>
        <div class="card-body">
            <form class="form-horizontal" action="{{ route('seller.bulk_product_upload') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="form-group row">
                    <label class="col-md-2 col-form-label">{{ translate('CSV') }}</label>
                    <div class="col-sm-10">
                        <div class="custom-file">
    						<label class="custom-file-label">
    							<input type="file" name="bulk_file" class="custom-file-input" required>
    							<span class="custom-file-name">{{ translate('Escolha arquivo')}}</span>
    						</label>
    					</div>
                    </div>
                </div>
                <div class="form-group mb-0 text-right">
                    <button type="submit" class="btn btn-primary">{{translate('Carregar CSV')}}</button>
                </div>
            </form>
        </div>
    </div>

@endsection
