@extends('seller.layouts.app')

@section('panel_content')
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6">{{ translate('Consultas de produtos') }}</h5>
        </div>
        <div class="card-body">
            <table class="table aiz-table mb-0" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th data-breakpoints="lg">#</th>
                        <th>{{ translate('Nome de usuário') }}</th>
                        <th>{{ translate('Nome do produto') }}</th>
                        <th data-breakpoints="lg">{{ translate('Pergunta') }}</th>
                        <th data-breakpoints="lg">{{ translate('Responder') }}</th>
                        <th>{{ translate('status') }}</th>
                        <th class="text-right">{{ translate('Opções') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($queries as $key => $query)
                        <tr>
                            <td>{{ $queries->firstItem() + $key }}</td>
                            <td>
								
								@if(isset($query->user->name))
									{{ $query->user->name }}
								@else
									{{ translate('Cliente não encontrado') }}
								@endif
							</td>
                            <td>
								@if(isset($query->product->name))
									{{ $query->product->name }}
								@else
									{{ translate('Produto não encontrado') }}
								@endif
							</td>
                            <td>{{ Str::limit($query->question, 100) }}</td>
                            <td>{{ Str::limit($query->reply, 100) }}</td>
                            <td>
                                <span
                                    class="badge badge-inline {{ $query->reply == null ? 'badge-warning' : 'badge-success' }}">
                                    {{ $query->reply == null ? translate('Não respondido') : translate('Respondeu') }}
                                </span>
                            </td>
                            <td class="text-right">
                                <a class="btn btn-soft-primary btn-icon btn-circle btn-sm"
                                    href="{{ route('seller.product_query.show', encrypt($query->id)) }}"
                                    title="{{ translate('Visualizar') }}">
                                    <i class="las la-eye"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination">
                {{ $queries->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
@endsection

@section('modal')
    @include('modals.delete_modal')
@endsection
