

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6"><?php echo e(translate('Contatos')); ?></h5>
        </div>
        <div class="card-body">
            <table class="table aiz-table mb-0 " cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo e(translate('Nome')); ?></th>
                        <th ><?php echo e(translate('E-mail')); ?></th>
                        <th data-breakpoints="lg"><?php echo e(translate('Telefone')); ?></th>
                        <th data-breakpoints="lg"><?php echo e(translate('Consulta')); ?></th>
                        <th data-breakpoints="lg"><?php echo e(translate('Responder')); ?></th>
                        <th><?php echo e(translate('status')); ?></th>
                        <th class="text-right"><?php echo e(translate('Opções')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(translate($key + 1)); ?></td>
                            <td><?php echo e($contact->name); ?></td>
                            <td><?php echo e($contact->email); ?></td>
                            <td><?php echo e($contact->phone); ?></td>
                            <td><?php echo e(Str::limit($contact->content, 100)); ?></td>
                            <td><?php echo e(Str::limit($contact->reply, 100)); ?></td>
                            <td>
                                <span
                                    class="badge badge-inline <?php echo e($contact->reply == null ? 'badge-warning' : 'badge-success'); ?>">
                                    <?php echo e($contact->reply == null ? translate('Não respondido') : translate('Respondeu')); ?>

                                </span>
                            </td>
                            <td class="text-right">
                                <a class="btn btn-soft-primary btn-icon btn-circle btn-sm"
                                    href="javascript:void(1)" onclick="showQuery(<?php echo e($contact->id); ?>)"
                                    title="<?php echo e(translate('Visualizar')); ?>">
                                    <i class="las la-eye"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="aiz-pagination">
                <?php echo e($contacts->appends(request()->input())->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <?php echo $__env->make('modals.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Query Modal -->
	<div class="modal fade" id="query_modal">
	    <div class="modal-dialog">
	        <div class="modal-content" id="query-modal-content">

	        </div>
	    </div>
	</div>
    <!-- Reply Modal -->
    <div class="modal fade" id="reply_modal">
        <div class="modal-dialog">
            <div class="modal-content" id="reply-modal-content">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function showQuery(id){
            $.post("<?php echo e(route('contact.query_modal')); ?>",{_token:'<?php echo e(@csrf_token()); ?>', id:id}, function(data){
                $('#query_modal #query-modal-content').html(data);
                $('#query_modal').modal('show');
            });
        }
        function showReplyModal(id){
            $.post("<?php echo e(route('contact.reply_modal')); ?>",{_token:'<?php echo e(@csrf_token()); ?>', id:id}, function(data){
                $('#reply_modal #reply-modal-content').html(data);
                $('#reply_modal').modal('show');
                $('#query_modal').modal('hide');
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hoogli/samambaia.hoogli.partners/resources/views/backend/support/contact/contacts.blade.php ENDPATH**/ ?>