

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-xxl-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="fs-18 mb-0 text-center"><?php echo e(translate('Credenciais do sistema de arquivos S3')); ?></h3>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="<?php echo e(route('payment_method.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="AWS_ACCESS_KEY_ID">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('AWS_ACCESS_KEY_ID')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="AWS_ACCESS_KEY_ID" value="<?php echo e(env('AWS_ACCESS_KEY_ID')); ?>" placeholder="<?php echo e(translate('AWS_ACCESS_KEY_ID')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="AWS_SECRET_ACCESS_KEY">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('AWS_SECRET_ACCESS_KEY')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="AWS_SECRET_ACCESS_KEY" value="<?php echo e(env('AWS_SECRET_ACCESS_KEY')); ?>" placeholder="<?php echo e(translate('AWS_SECRET_ACCESS_KEY')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="AWS_DEFAULT_REGION">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('AWS_DEFAULT_REGION')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="AWS_DEFAULT_REGION" value="<?php echo e(env('AWS_DEFAULT_REGION')); ?>" placeholder="<?php echo e(translate('AWS_DEFAULT_REGION')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="AWS_BUCKET">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('AWS_BUCKET')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="AWS_BUCKET" value="<?php echo e(env('AWS_BUCKET')); ?>" placeholder="<?php echo e(translate('AWS_BUCKET')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="AWS_URL">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('AWS_URL')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="AWS_URL" value="<?php echo e(env('AWS_URL')); ?>" placeholder="<?php echo e(translate('AWS_URL')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-primary" type="submit"><?php echo e(translate('Salvar')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="fs-18 mb-0 text-center"><?php echo e(translate('Credenciais do sistema de arquivos Backblaze')); ?></h3>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="<?php echo e(route('payment_method.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="BACKBLAZE_ACCESS_KEY_ID">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('BACKBLAZE_ACCESS_KEY_ID')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="BACKBLAZE_ACCESS_KEY_ID" value="<?php echo e(env('BACKBLAZE_ACCESS_KEY_ID')); ?>" placeholder="<?php echo e(translate('BACKBLAZE_ACCESS_KEY_ID')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="BACKBLAZE_SECRET_ACCESS_KEY">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('BACKBLAZE_SECRET_ACCESS_KEY')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="BACKBLAZE_SECRET_ACCESS_KEY" value="<?php echo e(env('BACKBLAZE_SECRET_ACCESS_KEY')); ?>" placeholder="<?php echo e(translate('BACKBLAZE_SECRET_ACCESS_KEY')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="BACKBLAZE_DEFAULT_REGION">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('BACKBLAZE_DEFAULT_REGION')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="BACKBLAZE_DEFAULT_REGION" value="<?php echo e(env('BACKBLAZE_DEFAULT_REGION')); ?>" placeholder="<?php echo e(translate('BACKBLAZE_DEFAULT_REGION')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="BACKBLAZE_BUCKET">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('BACKBLAZE_BUCKET')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="BACKBLAZE_BUCKET" value="<?php echo e(env('BACKBLAZE_BUCKET')); ?>" placeholder="<?php echo e(translate('BACKBLAZE_BUCKET')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="BACKBLAZE_ENDPOINT">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('PONTO FINAL DE RETROCESSO')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="BACKBLAZE_ENDPOINT" value="<?php echo e(env('BACKBLAZE_ENDPOINT')); ?>" placeholder="<?php echo e(translate('PONTO FINAL DE RETROCESSO')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="BACKBLAZE_URL">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('BACKBLAZE_URL')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="BACKBLAZE_URL" value="<?php echo e(env('BACKBLAZE_URL')); ?>" placeholder="<?php echo e(translate('BACKBLAZE_URL')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-primary" type="submit"><?php echo e(translate('Salvar')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-xxl-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="fs-18 mb-0 text-center"><?php echo e(translate('Ativação do sistema de arquivos AWS S3')); ?></h3>
                </div>
                <div class="card-body">
                    <label class="aiz-switch mb-0">
                        <input type="radio" name="FILESYSTEM_DRIVER" onchange="updateSettings(this, 'FILESYSTEM_DRIVER', 'aws')" <?php if(env('FILESYSTEM_DRIVER') == 'aws') echo "checked";?>>
                        <span></span>
                    </label>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="fs-18 mb-0 text-center"><?php echo e(translate('Ativação do sistema de arquivos Backblaze')); ?></h3>
                </div>
                <div class="card-body">
                    <label class="aiz-switch mb-0">
                        <input type="radio" name="FILESYSTEM_DRIVER" onchange="updateSettings(this, 'FILESYSTEM_DRIVER', 'backblaze')" <?php if(env('FILESYSTEM_DRIVER') == 'backblaze') echo "checked";?>>
                        <span></span>
                    </label>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="fs-18 mb-0 text-center"><?php echo e(translate('Ativação do sistema de arquivos local')); ?></h3>
                </div>
                <div class="card-body">
                    <label class="aiz-switch mb-0">
                        <input type="radio" name="FILESYSTEM_DRIVER" onchange="updateSettings(this, 'FILESYSTEM_DRIVER', 'local')" <?php if(env('FILESYSTEM_DRIVER') == 'local') echo "checked";?>>
                        <span></span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xxl-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="fs-18 mb-0 text-center"><?php echo e(translate('Cache e driver de sessão')); ?></h3>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="<?php echo e(route('payment_method.update')); ?>" method="POST">
                        <input type="hidden" name="payment_method" value="paypal">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="CACHE_DRIVER">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('CACHE_DRIVER')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <select class="form-control aiz-selectpicker mb-2 mb-md-0" name="CACHE_DRIVER">
                                    <option value="file" <?php if(env('CACHE_DRIVER') == "file"): ?> selected <?php endif; ?>><?php echo e(translate('arquivo')); ?></option>
                                    <option value="redis" <?php if(env('CACHE_DRIVER') == "redis"): ?> selected <?php endif; ?>><?php echo e(translate('redis')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="SESSION_DRIVER">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('SESSION_DRIVER')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <select class="form-control aiz-selectpicker mb-2 mb-md-0" name="SESSION_DRIVER">
                                    <option value="file" <?php if(env('SESSION_DRIVER') == "file"): ?> selected <?php endif; ?>><?php echo e(translate('arquivo')); ?></option>
                                    <option value="redis" <?php if(env('SESSION_DRIVER') == "redis"): ?> selected <?php endif; ?>><?php echo e(translate('redis')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-primary" type="submit"><?php echo e(translate('Salvar')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-xxl-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="fs-18 mb-0 text-center"><?php echo e(translate('Configuração do Redis (se você usar o redis como qualquer um dos drivers)')); ?></h3>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="<?php echo e(route('payment_method.update')); ?>" method="POST">
                        <input type="hidden" name="payment_method" value="paypal">
                        <?php echo csrf_field(); ?>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="REDIS_HOST">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('REDIS_HOST')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="REDIS_HOST" value="<?php echo e(env('REDIS_HOST')); ?>" placeholder="<?php echo e(translate('REDIS_HOST')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="REDIS_PASSWORD">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('REDIS_SENHA')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="REDIS_PASSWORD" value="<?php echo e(env('REDIS_PASSWORD')); ?>" placeholder="<?php echo e(translate('REDIS_SENHA')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="REDIS_PORT">
                            <div class="col-lg-4">
                                <label class="control-label"><?php echo e(translate('REDIS_PORT')); ?></label>
                            </div>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="REDIS_PORT" value="<?php echo e(env('REDIS_PORT')); ?>" placeholder="<?php echo e(translate('REDIS_PORT')); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-primary" type="submit"><?php echo e(translate('Salvar')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function updateSettings(el, type, value_type){

            if('<?php echo e(env('DEMO_MODE')); ?>' == 'On'){
                AIZ.plugins.notify('info', '<?php echo e(translate('Os dados não podem ser alterados no modo de demonstração.')); ?>');
                return;
            }

            $.post('<?php echo e(route('business_settings.update.activation')); ?>', {
                _token:'<?php echo e(csrf_token()); ?>',
                type:type,
                value:value_type
            }, function(data){
                if(data == 1){
                    AIZ.plugins.notify('success', '<?php echo e(translate('Configurações atualizadas com sucesso')); ?>');
                }
                else{
                    AIZ.plugins.notify('danger', '<?php echo e(translate('Algo deu errado')); ?>');
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hoogli/samambaia.hoogli.partners/resources/views/backend/setup_configurations/file_system.blade.php ENDPATH**/ ?>