<?php $__env->startSection('content'); ?>
  <!--==============================
    Breadcumb
============================== -->
    <div class="breadcumb-wrapper " data-bg-src="<?php echo e(uploaded_asset($blogall->banner ?? '')); ?>">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-9">
                    <div class="breadcumb-content">
                        <h1 class="breadcumb-title">Blog Post</h1>
                        <ul class="breadcumb-menu">
                            <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li>Blog</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div><!--==============================
Blog Area
==============================-->
    <section class="th-blog-wrapper space-top space-extra-bottom">
        <div class="container">
            <div class="row">
                <div class="col-xxl-8 col-lg-7">
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="th-blog blog-single has-post-thumbnail">
                            <div class="blog-img">
                                <a href="<?php echo e(url("blog").'/'. $blog->slug); ?>"><img src="<?php echo e(uploaded_asset($blog->banner)); ?>" alt="<?php echo e($blog->title); ?>"></a>
                            </div>
                            <div class="blog-content">
                                <div class="blog-meta">
                                    <a href="<?php echo e(url('blog') . '/' . $blog->slug); ?>" class="text-theme"><i class="far fa-clock text-theme"></i><?php echo e(date('d M Y',strtotime($blog->created_at))); ?></a>
                                    <?php if($blog->category != null): ?>
                                        <a href="<?php echo e(url('blog') .'/'. $blog->slug); ?>" class="text-theme"><i class="far fa-house-building text-theme"></i><?php echo e($blog->category->category_name); ?></a>
                                    <?php endif; ?>
                                    
                                </div>
                                <h2 class="blog-title"><a href="<?php echo e(url('blog') .'/'. $blog->slug); ?>"><?php echo e($blog->title); ?></a></h2>
                                <p class="blog-text"><?php echo e($blog->short_description); ?></p>
                                <a href="<?php echo e(url("blog").'/'. $blog->slug); ?>" class="th-btn style-border2 th-btn-icon"><?php echo e(translate('Leia mais')); ?></a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="th-pagination">
                        <?php echo e($blogs->links()); ?>

                    </div>
                </div>
                <div class="col-xxl-4 col-lg-5">
                    <aside class="sidebar-area">
                        <div class="widget widget_search">
                            <form class="search-form" action="<?php echo e(route('blog')); ?>" method="GET">
                                <input type="text" name="search" placeholder="Procurar..." value="<?php echo e(request('search')); ?>">
                            
                                <?php if(request()->has('selected_categories')): ?>
                                    <input type="hidden" name="selected_categories" value="<?php echo e(request('selected_categories')); ?>">
                                <?php endif; ?>
                        
                                <button type="submit"><i class="far fa-search"></i></button>
                            </form>
                        </div>
                        <div class="widget widget_categories  ">
                            <h3 class="widget_title"><?php echo e(translate('Categorias')); ?></h3>
                            <ul>
                                <?php $__currentLoopData = $allcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e(route('blog', ['selected_categories' => $category->slug, 'search' => request('search')])); ?>">
                                            <?php echo e($category->category_name); ?>

                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class="widget  ">
                            <h3 class="widget_title"><?php echo e(translate('Blogs Recentes')); ?></h3>
                            <div class="recent-post-wrap">
                                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="recent-post">
                                        <div class="media-img">
                                            <a href="<?php echo e(url("blog").'/'. $blog->slug); ?>"><img src="<?php echo e(uploaded_asset($blog->banner)); ?>" alt="<?php echo e($blog->title); ?>"></a>
                                        </div>
                                        <div class="media-body">
                                            <h4 class="post-title"><a class="text-inherit" href="<?php echo e(url("blog").'/'. $blog->slug); ?>"><?php echo e($blog->title); ?></a></h4>
                                            <div class="recent-post-meta">
                                                <a href="<?php echo e(url("blog").'/'. $blog->slug); ?>"><i class="far fa-calendar"></i><?php echo e(date('d M Y',strtotime($blog->created_at))); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="widget widget_banner  " data-bg-src="assets/img/widget/widget-banner.png">
                            <div class="widget-banner text-center">
                                <h3 class="title"><?php echo e($blogall->title ?? ''); ?></h3>
                                <div class="logo"><img src="<?php echo e(uploaded_asset($blogall->image ?? '' )); ?>" alt="img"></div>
                                <h4 class="subtitle"><?php echo e($blogall->subtitle ?? ''); ?></h4>
                                <h5 class="link"><a href="tel:<?php echo e(preg_replace('/[^0-9]/', '', $blogall->number ?? '' )); ?>"><?php echo e($blogall->number ?? ''); ?></a></h5>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hooglicl/topazio.hoogli.cloud/resources/views/frontend/themes/clinica/blog.blade.php ENDPATH**/ ?>