

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6"><?php echo e(translate('Configurações SMTP')); ?></h5>
            </div>
            <div class="card-body">
                <form class="form-horizontal" action="<?php echo e(route('env_key_update.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group row">
                        <input type="hidden" name="types[]" value="MAIL_DRIVER">
                        <label class="col-md-3 col-form-label"><?php echo e(translate('Tipo')); ?></label>
                        <div class="col-md-9">
                            <select class="form-control aiz-selectpicker mb-2 mb-md-0" name="MAIL_DRIVER" onchange="checkMailDriver()">
                                <option value="sendmail" <?php if(env('MAIL_DRIVER') == "sendmail"): ?> selected <?php endif; ?>><?php echo e(translate('Enviar e-mail')); ?></option>
                                <option value="smtp" <?php if(env('MAIL_DRIVER') == "smtp"): ?> selected <?php endif; ?>><?php echo e(translate('SMTP')); ?></option>
                                <option value="mailgun" <?php if(env('MAIL_DRIVER') == "mailgun"): ?> selected <?php endif; ?>><?php echo e(translate('milgun')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div id="smtp">
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAIL_HOST">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('HOST DE CORREIO')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="MAIL_HOST" value="<?php echo e(env('MAIL_HOST')); ?>" placeholder="<?php echo e(translate('HOST DE CORREIO')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAIL_PORT">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('PORTA DE CORREIO')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="MAIL_PORT" value="<?php echo e(env('MAIL_PORT')); ?>" placeholder="<?php echo e(translate('PORTA DE CORREIO')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAIL_USERNAME">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('E-MAIL NOME DE USUÁRIO')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="MAIL_USERNAME" value="<?php echo e(env('MAIL_USERNAME')); ?>" placeholder="<?php echo e(translate('E-MAIL NOME DE USUÁRIO')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAIL_PASSWORD">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('SENHA DE CORREIO')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="MAIL_PASSWORD" value="<?php echo e(env('MAIL_PASSWORD')); ?>" placeholder="<?php echo e(translate('SENHA DE CORREIO')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAIL_ENCRYPTION">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('CRIPTOGRAFIA DE CORREIO')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="MAIL_ENCRYPTION" value="<?php echo e(env('MAIL_ENCRYPTION')); ?>" placeholder="<?php echo e(translate('CRIPTOGRAFIA DE CORREIO')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAIL_FROM_ADDRESS">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('CORREIO DO ENDEREÇO')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="email" class="form-control" name="MAIL_FROM_ADDRESS" value="<?php echo e(env('MAIL_FROM_ADDRESS')); ?>" placeholder="<?php echo e(translate('CORREIO DO ENDEREÇO')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAIL_FROM_NAME">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('CORREIO DE NOME')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="MAIL_FROM_NAME" value="<?php echo e(env('MAIL_FROM_NAME')); ?>" placeholder="<?php echo e(translate('CORREIO DE NOME')); ?>">
                            </div>
                        </div>
                    </div>
                    <div id="mailgun">
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAILGUN_DOMAIN">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('DOMÍNIO DO MAILGUN')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="MAILGUN_DOMAIN" value="<?php echo e(env('MAILGUN_DOMAIN')); ?>" placeholder="<?php echo e(translate('DOMÍNIO DO MAILGUN')); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAILGUN_SECRET">
                            <div class="col-md-3">
                                <label class="col-from-label"><?php echo e(translate('SEGREDO DA ARMA DE CORREIO')); ?></label>
                            </div>
                            <div class="col-md-9">
                                <input type="text" class="form-control" name="MAILGUN_SECRET" value="<?php echo e(env('MAILGUN_SECRET')); ?>" placeholder="<?php echo e(translate('SEGREDO DA ARMA DE CORREIO')); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary"><?php echo e(translate('Salvar configuração')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6"><?php echo e(translate('Testar configuração SMTP')); ?></h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('test.smtp')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col">
                            <input type="email" class="form-control" name="email" value="<?php echo e(auth()->user()->email); ?>" placeholder="<?php echo e(translate('Digite seu endereço de e-mail')); ?>">
                        </div>
                        <div class="col-auto">
                            <button type="submit" class="btn btn-primary"><?php echo e(translate('Enviar e-mail de teste')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6"><?php echo e(translate('Instrução')); ?></h5>
            </div>
            <div class="card-body">
                <p class="text-danger"><?php echo e(translate('Tenha cuidado ao configurar o SMTP. Por configuração incorreta você receberá erro no momento da realização do pedido, novo cadastro, envio de newsletter.')); ?></p>
                <h6 class="text-muted"><?php echo e(translate('Para não-SSL')); ?></h6>
                <ul class="list-group">
                    <li class="list-group-item text-dark"><?php echo e(translate('Selecione sendmail para Mail Driver se você enfrentar algum problema após configurar smtp como Mail Driver')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Defina o Mail Host de acordo com as configurações manuais do cliente de email do seu servidor')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Defina a porta do Mail como 587')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Defina a criptografia de correio como SSL se você enfrentar problemas com tls')); ?></li>
                </ul>
                <br>
                <h6 class="text-muted"><?php echo e(translate('Para SSL')); ?></h6>
                <ul class="list-group mar-no">
                    <li class="list-group-item text-dark"><?php echo e(translate('Selecione sendmail para Mail Driver se você enfrentar algum problema após configurar smtp como Mail Driver')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Defina o Mail Host de acordo com as configurações manuais do cliente de email do seu servidor')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Defina a porta de correio como 465')); ?></li>
                    <li class="list-group-item text-dark"><?php echo e(translate('Definir criptografia de correio como SSL')); ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script type="text/javascript">
        $(document).ready(function(){
            checkMailDriver();
        });
        function checkMailDriver(){
            if($('select[name=MAIL_DRIVER]').val() == 'mailgun'){
                $('#mailgun').show();
                $('#smtp').hide();
            }
            else{
                $('#mailgun').hide();
                $('#smtp').show();
            }
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hoogli/samambaia.hoogli.partners/resources/views/backend/setup_configurations/smtp_settings.blade.php ENDPATH**/ ?>