<?php
require 'vendor/autoload.php';

use Stichoza\GoogleTranslate\GoogleTranslate;

function translateBladeFiles($directory) {
    $tr = new GoogleTranslate('pt-BR');

    $items = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));

    foreach ($items as $item) {
        if ($item->isFile() && pathinfo($item, PATHINFO_EXTENSION) === 'php' && strpos($item->getFilename(), '.blade.php') !== false) {
            $filePath = $item->getPathname();
            $content = file_get_contents($filePath);
            $pattern = '/translate\(\'(.*?)\'\)/';
            $newContent = preg_replace_callback($pattern, function ($matches) use ($tr) {
                $translated = $tr->translate($matches[1]);
                return "translate('{$translated}')";
            }, $content);
            if ($newContent !== $content) {
                file_put_contents($filePath, $newContent);
                echo "Arquivo {$filePath} traduzido com sucesso.\n";
            }
        }
    }
}
$directory = 'resources/views';
translateBladeFiles($directory);
